/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.jaeger;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Channel;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.opentelemetry.exporter.jaeger.Adapter;
import io.opentelemetry.exporter.jaeger.proto.api_v2.Collector;
import io.opentelemetry.exporter.jaeger.proto.api_v2.CollectorServiceGrpc;
import io.opentelemetry.exporter.jaeger.proto.api_v2.Model;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.export.ConfigBuilder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class JaegerGrpcSpanExporter
implements SpanExporter {
    public static final String DEFAULT_HOST_NAME = "unknown";
    public static final String DEFAULT_ENDPOINT = "localhost:14250";
    public static final String DEFAULT_SERVICE_NAME = "unknown";
    public static final long DEFAULT_DEADLINE_MS = TimeUnit.SECONDS.toMillis(10L);
    private static final Logger logger = Logger.getLogger(JaegerGrpcSpanExporter.class.getName());
    private static final String CLIENT_VERSION_KEY = "jaeger.version";
    private static final String CLIENT_VERSION_VALUE = "opentelemetry-java";
    private static final String HOSTNAME_KEY = "hostname";
    private static final String IP_KEY = "ip";
    private static final String IP_DEFAULT = "0.0.0.0";
    private final CollectorServiceGrpc.CollectorServiceFutureStub stub;
    private final Model.Process.Builder processBuilder;
    private final ManagedChannel managedChannel;
    private final long deadlineMs;

    private JaegerGrpcSpanExporter(String serviceName, ManagedChannel channel, long deadlineMs) {
        String ipv4;
        String hostname;
        if (serviceName == null || serviceName.trim().length() == 0) {
            throw new IllegalArgumentException("Service name must not be null or empty");
        }
        try {
            hostname = InetAddress.getLocalHost().getHostName();
            ipv4 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            hostname = "unknown";
            ipv4 = IP_DEFAULT;
        }
        Model.KeyValue clientTag = Model.KeyValue.newBuilder().setKey(CLIENT_VERSION_KEY).setVStr(CLIENT_VERSION_VALUE).build();
        Model.KeyValue ipv4Tag = Model.KeyValue.newBuilder().setKey(IP_KEY).setVStr(ipv4).build();
        Model.KeyValue hostnameTag = Model.KeyValue.newBuilder().setKey(HOSTNAME_KEY).setVStr(hostname).build();
        this.processBuilder = Model.Process.newBuilder().setServiceName(serviceName).addTags(clientTag).addTags(ipv4Tag).addTags(hostnameTag);
        this.managedChannel = channel;
        this.stub = CollectorServiceGrpc.newFutureStub((Channel)channel);
        this.deadlineMs = deadlineMs;
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        CollectorServiceGrpc.CollectorServiceFutureStub stub = this.stub;
        if (this.deadlineMs > 0L) {
            stub = (CollectorServiceGrpc.CollectorServiceFutureStub)stub.withDeadlineAfter(this.deadlineMs, TimeUnit.MILLISECONDS);
        }
        ArrayList requests = new ArrayList();
        spans.stream().collect(Collectors.groupingBy(SpanData::getResource)).forEach((resource, spanData) -> requests.add(this.buildRequest((Resource)resource, (List<SpanData>)spanData)));
        ArrayList<ListenableFuture<Collector.PostSpansResponse>> listenableFutures = new ArrayList<ListenableFuture<Collector.PostSpansResponse>>(requests.size());
        for (Collector.PostSpansRequest request : requests) {
            listenableFutures.add(stub.postSpans(request));
        }
        final CompletableResultCode result = new CompletableResultCode();
        final AtomicInteger pending = new AtomicInteger(listenableFutures.size());
        final AtomicReference error = new AtomicReference();
        for (ListenableFuture listenableFuture : listenableFutures) {
            Futures.addCallback((ListenableFuture)listenableFuture, (FutureCallback)new FutureCallback<Collector.PostSpansResponse>(){

                public void onSuccess(Collector.PostSpansResponse result2) {
                    this.fulfill();
                }

                public void onFailure(Throwable t) {
                    error.set(t);
                    this.fulfill();
                }

                private void fulfill() {
                    if (pending.decrementAndGet() == 0) {
                        Throwable t = (Throwable)error.get();
                        if (t != null) {
                            logger.log(Level.WARNING, "Failed to export spans", t);
                            result.fail();
                        } else {
                            result.succeed();
                        }
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
        return result;
    }

    private Collector.PostSpansRequest buildRequest(Resource resource, List<SpanData> spans) {
        Model.Process.Builder builder = this.processBuilder.clone();
        builder.addAllTags(Adapter.toKeyValues(resource.getAttributes()));
        return Collector.PostSpansRequest.newBuilder().setBatch(Model.Batch.newBuilder().addAllSpans(Adapter.toJaeger(spans)).setProcess(builder.build()).build()).build();
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public static Builder builder() {
        return new Builder();
    }

    public CompletableResultCode shutdown() {
        final CompletableResultCode result = new CompletableResultCode();
        this.managedChannel.notifyWhenStateChanged(ConnectivityState.SHUTDOWN, new Runnable(){

            @Override
            public void run() {
                result.succeed();
            }
        });
        this.managedChannel.shutdown();
        return result;
    }

    public static class Builder
    extends ConfigBuilder<Builder> {
        private static final String KEY_SERVICE_NAME = "otel.exporter.jaeger.service.name";
        private static final String KEY_ENDPOINT = "otel.exporter.jaeger.endpoint";
        private String serviceName = "unknown";
        private String endpoint = "localhost:14250";
        private ManagedChannel channel;
        private long deadlineMs = DEFAULT_DEADLINE_MS;

        public Builder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder setChannel(ManagedChannel channel) {
            this.channel = channel;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setDeadlineMs(long deadlineMs) {
            this.deadlineMs = deadlineMs;
            return this;
        }

        protected Builder fromConfigMap(Map<String, String> configMap, ConfigBuilder.NamingConvention namingConvention) {
            String stringValue = Builder.getStringProperty((String)KEY_SERVICE_NAME, (Map)(configMap = namingConvention.normalize(configMap)));
            if (stringValue != null) {
                this.setServiceName(stringValue);
            }
            if ((stringValue = Builder.getStringProperty((String)KEY_ENDPOINT, (Map)configMap)) != null) {
                this.setEndpoint(stringValue);
            }
            return this;
        }

        public JaegerGrpcSpanExporter build() {
            if (this.channel == null) {
                this.channel = ManagedChannelBuilder.forTarget((String)this.endpoint).usePlaintext().build();
            }
            return new JaegerGrpcSpanExporter(this.serviceName, this.channel, this.deadlineMs);
        }

        private Builder() {
        }
    }
}

