/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.context;

import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.ContextStorageProvider;
import io.opentelemetry.context.DefaultContext;
import io.opentelemetry.context.ThreadLocalContextStorage;
import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

final class LazyStorage {
    private static final String CONTEXT_STORAGE_PROVIDER_PROPERTY = "io.opentelemetry.context.contextStorageProvider";
    private static final Logger logger = Logger.getLogger(ThreadLocalContextStorage.class.getName());
    static final ContextStorage storage;

    private static ContextStorage createStorage(AtomicReference<Throwable> deferredStorageFailure) {
        String providerClassName = System.getProperty(CONTEXT_STORAGE_PROVIDER_PROPERTY, "");
        ArrayList<ContextStorageProvider> providers = new ArrayList<ContextStorageProvider>();
        for (ContextStorageProvider provider : ServiceLoader.load(ContextStorageProvider.class)) {
            providers.add(provider);
        }
        if (providers.isEmpty()) {
            return DefaultContext.threadLocalStorage();
        }
        if (providers.size() == 1) {
            ContextStorageProvider provider = (ContextStorageProvider)providers.get(0);
            try {
                return provider.get();
            }
            catch (Throwable t) {
                deferredStorageFailure.set(t);
                return DefaultContext.threadLocalStorage();
            }
        }
        if (providerClassName.isEmpty()) {
            deferredStorageFailure.set(new IllegalStateException("Found multiple ContextStorageProvider. Set the io.opentelemetry.context.ContextStorageProvider property to the fully qualified class name of the provider to use. Falling back to default ContextStorage. Found providers: " + providers));
            return DefaultContext.threadLocalStorage();
        }
        for (ContextStorageProvider provider : providers) {
            if (!provider.getClass().getName().equals(providerClassName)) continue;
            return provider.get();
        }
        deferredStorageFailure.set(new IllegalStateException("io.opentelemetry.context.ContextStorageProvider property set but no matching class could be found, requested: " + providerClassName + " but found providers: " + providers));
        return DefaultContext.threadLocalStorage();
    }

    private LazyStorage() {
    }

    static {
        AtomicReference<Throwable> deferredStorageFailure = new AtomicReference<Throwable>();
        storage = LazyStorage.createStorage(deferredStorageFailure);
        Throwable failure = deferredStorageFailure.get();
        if (failure != null) {
            logger.log(Level.WARNING, "ContextStorageProvider initialized failed. Using default", failure);
        }
    }
}

