/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.context;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.PersistentHashArrayMappedTrie;
import io.opentelemetry.context.ThreadLocalContextStorage;
import javax.annotation.Nullable;

final class DefaultContext
implements Context {
    static final Context ROOT = new DefaultContext();
    @Nullable
    private final PersistentHashArrayMappedTrie.Node<ContextKey<?>, Object> entries;

    static ContextStorage threadLocalStorage() {
        return ThreadLocalContextStorage.INSTANCE;
    }

    private DefaultContext(PersistentHashArrayMappedTrie.Node<ContextKey<?>, Object> entries) {
        this.entries = entries;
    }

    DefaultContext() {
        this.entries = null;
    }

    @Override
    @Nullable
    public <V> V getValue(ContextKey<V> key) {
        Object value = PersistentHashArrayMappedTrie.get(this.entries, key);
        return (V)value;
    }

    @Override
    public <V> Context withValues(ContextKey<V> k1, V v1) {
        PersistentHashArrayMappedTrie.Node<ContextKey<?>, Object> newEntries = PersistentHashArrayMappedTrie.put(this.entries, k1, v1);
        return new DefaultContext(newEntries);
    }

    @Override
    public <V1, V2> Context withValues(ContextKey<V1> k1, V1 v1, ContextKey<V2> k2, V2 v2) {
        PersistentHashArrayMappedTrie.Node<ContextKey<?>, Object> newEntries = PersistentHashArrayMappedTrie.put(this.entries, k1, v1);
        newEntries = PersistentHashArrayMappedTrie.put(newEntries, k2, v2);
        return new DefaultContext(newEntries);
    }

    @Override
    public <V1, V2, V3> Context withValues(ContextKey<V1> k1, V1 v1, ContextKey<V2> k2, V2 v2, ContextKey<V3> k3, V3 v3) {
        PersistentHashArrayMappedTrie.Node<ContextKey<?>, Object> newEntries = PersistentHashArrayMappedTrie.put(this.entries, k1, v1);
        newEntries = PersistentHashArrayMappedTrie.put(newEntries, k2, v2);
        newEntries = PersistentHashArrayMappedTrie.put(newEntries, k3, v3);
        return new DefaultContext(newEntries);
    }

    @Override
    public <V1, V2, V3, V4> Context withValues(ContextKey<V1> k1, V1 v1, ContextKey<V2> k2, V2 v2, ContextKey<V3> k3, V3 v3, ContextKey<V4> k4, V4 v4) {
        PersistentHashArrayMappedTrie.Node<ContextKey<?>, Object> newEntries = PersistentHashArrayMappedTrie.put(this.entries, k1, v1);
        newEntries = PersistentHashArrayMappedTrie.put(newEntries, k2, v2);
        newEntries = PersistentHashArrayMappedTrie.put(newEntries, k3, v3);
        newEntries = PersistentHashArrayMappedTrie.put(newEntries, k4, v4);
        return new DefaultContext(newEntries);
    }
}

