/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.trace;

import io.opentelemetry.api.internal.OtelEncodingUtils;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TraceId {
    private static final ThreadLocal<char[]> charBuffer = new ThreadLocal();
    private static final int BYTES_LENGTH = 16;
    private static final int HEX_LENGTH = 32;
    private static final String INVALID = "00000000000000000000000000000000";

    private TraceId() {
    }

    public static int getLength() {
        return 32;
    }

    public static String getInvalid() {
        return INVALID;
    }

    public static boolean isValid(CharSequence traceId) {
        return traceId != null && traceId.length() == 32 && !INVALID.contentEquals(traceId) && OtelEncodingUtils.isValidBase16String(traceId);
    }

    public static String fromBytes(byte[] traceIdBytes) {
        if (traceIdBytes == null || traceIdBytes.length < 16) {
            return INVALID;
        }
        char[] result = TraceId.getTemporaryBuffer();
        OtelEncodingUtils.bytesToBase16(traceIdBytes, result, 16);
        return new String(result);
    }

    public static String fromLongs(long traceIdLongHighPart, long traceIdLongLowPart) {
        if (traceIdLongHighPart == 0L && traceIdLongLowPart == 0L) {
            return TraceId.getInvalid();
        }
        char[] chars = TraceId.getTemporaryBuffer();
        OtelEncodingUtils.longToBase16String(traceIdLongHighPart, chars, 0);
        OtelEncodingUtils.longToBase16String(traceIdLongLowPart, chars, 16);
        return new String(chars);
    }

    private static char[] getTemporaryBuffer() {
        char[] chars = charBuffer.get();
        if (chars == null) {
            chars = new char[32];
            charBuffer.set(chars);
        }
        return chars;
    }
}

