/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.trace;

import io.opentelemetry.internal.Utils;
import io.opentelemetry.trace.BigendianEncoding;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SpanId
implements Comparable<SpanId> {
    private static final int SIZE = 8;
    private static final int BASE16_SIZE = 16;
    private static final long INVALID_ID = 0L;
    private static final SpanId INVALID = new SpanId(0L);
    private final long id;

    public SpanId(long id) {
        this.id = id;
    }

    public static int getSize() {
        return 8;
    }

    public static SpanId getInvalid() {
        return INVALID;
    }

    public static SpanId fromBytes(byte[] src, int srcOffset) {
        Utils.checkNotNull(src, "src");
        return new SpanId(BigendianEncoding.longFromByteArray(src, srcOffset));
    }

    public void copyBytesTo(byte[] dest, int destOffset) {
        BigendianEncoding.longToByteArray(this.id, dest, destOffset);
    }

    public static SpanId fromLowerBase16(CharSequence src, int srcOffset) {
        Utils.checkNotNull(src, "src");
        return new SpanId(BigendianEncoding.longFromBase16String(src, srcOffset));
    }

    public void copyLowerBase16To(char[] dest, int destOffset) {
        BigendianEncoding.longToBase16String(this.id, dest, destOffset);
    }

    public boolean isValid() {
        return this.id != 0L;
    }

    public String toLowerBase16() {
        char[] chars = new char[16];
        this.copyLowerBase16To(chars, 0);
        return new String(chars);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SpanId)) {
            return false;
        }
        SpanId that = (SpanId)obj;
        return this.id == that.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public String toString() {
        return "SpanId{spanId=" + this.toLowerBase16() + "}";
    }

    @Override
    public int compareTo(SpanId that) {
        return this.id < that.id ? -1 : (this.id == that.id ? 0 : 1);
    }
}

