/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.common;

import com.google.auto.value.AutoValue;
import io.opentelemetry.common.AutoValue_AttributeValue_AttributeValueBoolean;
import io.opentelemetry.common.AutoValue_AttributeValue_AttributeValueBooleanArray;
import io.opentelemetry.common.AutoValue_AttributeValue_AttributeValueDouble;
import io.opentelemetry.common.AutoValue_AttributeValue_AttributeValueDoubleArray;
import io.opentelemetry.common.AutoValue_AttributeValue_AttributeValueLong;
import io.opentelemetry.common.AutoValue_AttributeValue_AttributeValueLongArray;
import io.opentelemetry.common.AutoValue_AttributeValue_AttributeValueString;
import io.opentelemetry.common.AutoValue_AttributeValue_AttributeValueStringArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class AttributeValue {
    public static AttributeValue stringAttributeValue(String stringValue) {
        return AttributeValueString.create(stringValue);
    }

    public static AttributeValue booleanAttributeValue(boolean booleanValue) {
        return AttributeValueBoolean.create(booleanValue);
    }

    public static AttributeValue longAttributeValue(long longValue) {
        return AttributeValueLong.create(longValue);
    }

    public static AttributeValue doubleAttributeValue(double doubleValue) {
        return AttributeValueDouble.create(doubleValue);
    }

    public static AttributeValue arrayAttributeValue(String ... stringValues) {
        return AttributeValueStringArray.create(stringValues);
    }

    public static AttributeValue arrayAttributeValue(Boolean ... booleanValues) {
        return AttributeValueBooleanArray.create(booleanValues);
    }

    public static AttributeValue arrayAttributeValue(Long ... longValues) {
        return AttributeValueLongArray.create(longValues);
    }

    public static AttributeValue arrayAttributeValue(Double ... doubleValues) {
        return AttributeValueDoubleArray.create(doubleValues);
    }

    AttributeValue() {
    }

    public String getStringValue() {
        throw new UnsupportedOperationException(String.format("This type can only return %s data", this.getType().name()));
    }

    public boolean getBooleanValue() {
        throw new UnsupportedOperationException(String.format("This type can only return %s data", this.getType().name()));
    }

    public long getLongValue() {
        throw new UnsupportedOperationException(String.format("This type can only return %s data", this.getType().name()));
    }

    public double getDoubleValue() {
        throw new UnsupportedOperationException(String.format("This type can only return %s data", this.getType().name()));
    }

    public List<String> getStringArrayValue() {
        throw new UnsupportedOperationException(String.format("This type can only return %s data", this.getType().name()));
    }

    public List<Boolean> getBooleanArrayValue() {
        throw new UnsupportedOperationException(String.format("This type can only return %s data", this.getType().name()));
    }

    public List<Long> getLongArrayValue() {
        throw new UnsupportedOperationException(String.format("This type can only return %s data", this.getType().name()));
    }

    public List<Double> getDoubleArrayValue() {
        throw new UnsupportedOperationException(String.format("This type can only return %s data", this.getType().name()));
    }

    public abstract Type getType();

    public boolean isNull() {
        return false;
    }

    @Immutable
    @AutoValue
    static abstract class AttributeValueDoubleArray
    extends AttributeValue {
        private static final AttributeValue EMPTY = new AutoValue_AttributeValue_AttributeValueDoubleArray(Collections.emptyList());

        AttributeValueDoubleArray() {
        }

        static AttributeValue create(Double ... doubleValues) {
            if (doubleValues == null) {
                return EMPTY;
            }
            ArrayList<Double> values = new ArrayList<Double>(doubleValues.length);
            values.addAll(Arrays.asList(doubleValues));
            return new AutoValue_AttributeValue_AttributeValueDoubleArray(Collections.unmodifiableList(values));
        }

        @Override
        public final Type getType() {
            return Type.DOUBLE_ARRAY;
        }

        @Override
        public boolean isNull() {
            return this == EMPTY;
        }

        @Override
        public abstract List<Double> getDoubleArrayValue();
    }

    @Immutable
    @AutoValue
    static abstract class AttributeValueLongArray
    extends AttributeValue {
        private static final AttributeValue EMPTY = new AutoValue_AttributeValue_AttributeValueLongArray(Collections.emptyList());

        AttributeValueLongArray() {
        }

        static AttributeValue create(Long ... longValues) {
            if (longValues == null) {
                return EMPTY;
            }
            ArrayList<Long> values = new ArrayList<Long>(longValues.length);
            values.addAll(Arrays.asList(longValues));
            return new AutoValue_AttributeValue_AttributeValueLongArray(Collections.unmodifiableList(values));
        }

        @Override
        public final Type getType() {
            return Type.LONG_ARRAY;
        }

        @Override
        public boolean isNull() {
            return this == EMPTY;
        }

        @Override
        public abstract List<Long> getLongArrayValue();
    }

    @Immutable
    @AutoValue
    static abstract class AttributeValueBooleanArray
    extends AttributeValue {
        private static final AttributeValue EMPTY = new AutoValue_AttributeValue_AttributeValueBooleanArray(Collections.emptyList());

        AttributeValueBooleanArray() {
        }

        static AttributeValue create(Boolean ... booleanValues) {
            if (booleanValues == null) {
                return EMPTY;
            }
            ArrayList<Boolean> values = new ArrayList<Boolean>(booleanValues.length);
            values.addAll(Arrays.asList(booleanValues));
            return new AutoValue_AttributeValue_AttributeValueBooleanArray(Collections.unmodifiableList(values));
        }

        @Override
        public final Type getType() {
            return Type.BOOLEAN_ARRAY;
        }

        @Override
        public boolean isNull() {
            return this == EMPTY;
        }

        @Override
        public abstract List<Boolean> getBooleanArrayValue();
    }

    @Immutable
    @AutoValue
    static abstract class AttributeValueStringArray
    extends AttributeValue {
        private static final AttributeValue EMPTY = new AutoValue_AttributeValue_AttributeValueStringArray(Collections.emptyList());

        AttributeValueStringArray() {
        }

        static AttributeValue create(String ... stringValues) {
            if (stringValues == null) {
                return EMPTY;
            }
            return new AutoValue_AttributeValue_AttributeValueStringArray(Collections.unmodifiableList(Arrays.asList(stringValues)));
        }

        @Override
        public final Type getType() {
            return Type.STRING_ARRAY;
        }

        @Override
        public boolean isNull() {
            return this == EMPTY;
        }

        @Override
        public abstract List<String> getStringArrayValue();
    }

    @Immutable
    @AutoValue
    static abstract class AttributeValueDouble
    extends AttributeValue {
        AttributeValueDouble() {
        }

        static AttributeValue create(double doubleValue) {
            return new AutoValue_AttributeValue_AttributeValueDouble(doubleValue);
        }

        @Override
        public final Type getType() {
            return Type.DOUBLE;
        }

        @Override
        public abstract double getDoubleValue();
    }

    @Immutable
    @AutoValue
    static abstract class AttributeValueLong
    extends AttributeValue {
        AttributeValueLong() {
        }

        static AttributeValue create(long longValue) {
            return new AutoValue_AttributeValue_AttributeValueLong(longValue);
        }

        @Override
        public final Type getType() {
            return Type.LONG;
        }

        @Override
        public abstract long getLongValue();
    }

    @Immutable
    @AutoValue
    static abstract class AttributeValueBoolean
    extends AttributeValue {
        AttributeValueBoolean() {
        }

        static AttributeValue create(boolean booleanValue) {
            return new AutoValue_AttributeValue_AttributeValueBoolean(booleanValue);
        }

        @Override
        public final Type getType() {
            return Type.BOOLEAN;
        }

        @Override
        public abstract boolean getBooleanValue();
    }

    @Immutable
    @AutoValue
    static abstract class AttributeValueString
    extends AttributeValue {
        AttributeValueString() {
        }

        static AttributeValue create(String stringValue) {
            return new AutoValue_AttributeValue_AttributeValueString(stringValue);
        }

        @Override
        public final Type getType() {
            return Type.STRING;
        }

        @Override
        public boolean isNull() {
            return this.getStringValue() == null;
        }

        @Override
        @Nullable
        public abstract String getStringValue();
    }

    public static enum Type {
        STRING,
        BOOLEAN,
        LONG,
        DOUBLE,
        STRING_ARRAY,
        BOOLEAN_ARRAY,
        LONG_ARRAY,
        DOUBLE_ARRAY;

    }
}

