/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.common;

import io.opentelemetry.common.ReadableKeyValuePairs;
import io.opentelemetry.internal.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
abstract class ImmutableKeyValuePairs<V>
implements ReadableKeyValuePairs<V> {
    ImmutableKeyValuePairs() {
    }

    List<Object> data() {
        return Collections.emptyList();
    }

    @Override
    public int size() {
        return this.data().size() / 2;
    }

    @Override
    public boolean isEmpty() {
        return this.data().isEmpty();
    }

    @Override
    public void forEach(ReadableKeyValuePairs.KeyValueConsumer<V> consumer) {
        for (int i = 0; i < this.data().size(); i += 2) {
            consumer.consume((String)this.data().get(i), this.data().get(i + 1));
        }
    }

    @Override
    @Nullable
    public V get(String key) {
        for (int i = 0; i < this.data().size(); i += 2) {
            if (!key.equals(this.data().get(i))) continue;
            return (V)this.data().get(i + 1);
        }
        return null;
    }

    static List<Object> sortAndFilter(Object[] data) {
        Utils.checkArgument(data.length % 2 == 0, "You must provide an even number of key/value pair arguments.");
        ImmutableKeyValuePairs.quickSort(data, 0, data.length - 2);
        return ImmutableKeyValuePairs.dedupe(data);
    }

    private static void quickSort(Object[] data, int leftIndex, int rightIndex) {
        if (leftIndex >= rightIndex) {
            return;
        }
        String pivotKey = data[rightIndex] == null ? "" : (String)data[rightIndex];
        int counter = leftIndex;
        for (int i = leftIndex; i <= rightIndex; i += 2) {
            String value;
            String string = value = data[i] == null ? "" : (String)data[i];
            if (value.compareTo(pivotKey) > 0) continue;
            ImmutableKeyValuePairs.swap(data, counter, i);
            counter += 2;
        }
        ImmutableKeyValuePairs.quickSort(data, leftIndex, counter - 4);
        ImmutableKeyValuePairs.quickSort(data, counter, rightIndex);
    }

    private static List<Object> dedupe(Object[] data) {
        ArrayList<Object> result = new ArrayList<Object>(data.length);
        Object previousKey = null;
        for (int i = 0; i < data.length; i += 2) {
            Object key = data[i];
            Object value = data[i + 1];
            if (key == null || "".equals(key) || key.equals(previousKey)) continue;
            previousKey = key;
            result.add(key);
            result.add(value);
        }
        return result;
    }

    private static void swap(Object[] data, int a, int b) {
        Object keyA = data[a];
        Object valueA = data[a + 1];
        data[a] = data[b];
        data[a + 1] = data[b + 1];
        data[b] = keyA;
        data[b + 1] = valueA;
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder("{");
        this.forEach(new ReadableKeyValuePairs.KeyValueConsumer<V>(){

            @Override
            public void consume(String key, V value) {
                sb.append(key).append("=").append(value).append(", ");
            }
        });
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append("}");
        return sb.toString();
    }
}

