/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.trace;

import com.google.auto.value.AutoValue;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.trace.AutoValue_TraceState;
import io.opentelemetry.trace.AutoValue_TraceState_Entry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class TraceState {
    private static final int KEY_MAX_SIZE = 256;
    private static final int VALUE_MAX_SIZE = 256;
    private static final int MAX_KEY_VALUE_PAIRS = 32;
    private static final TraceState DEFAULT = TraceState.builder().build();

    public static TraceState getDefault() {
        return DEFAULT;
    }

    @Nullable
    public String get(String key) {
        for (Entry entry : this.getEntries()) {
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public abstract List<Entry> getEntries();

    public static Builder builder() {
        return new Builder(Builder.EMPTY);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private static boolean validateKey(String key) {
        if (key.length() > 256 || key.isEmpty() || !TraceState.isNumberOrDigit(key.charAt(0))) {
            return false;
        }
        int atSeenCount = 0;
        for (int i = 1; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (!TraceState.isNumberOrDigit(c) && c != '_' && c != '-' && c != '@' && c != '*' && c != '/') {
                return false;
            }
            if (c != '@' || ++atSeenCount <= 1) continue;
            return false;
        }
        return true;
    }

    private static boolean isNumberOrDigit(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9';
    }

    private static boolean validateValue(String value) {
        if (value.length() > 256 || value.charAt(value.length() - 1) == ' ') {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c != ',' && c != '=' && c >= ' ' && c <= '~') continue;
            return false;
        }
        return true;
    }

    private static TraceState create(List<Entry> entries) {
        Utils.checkState(entries.size() <= 32, "Invalid size");
        return new AutoValue_TraceState(Collections.unmodifiableList(entries));
    }

    TraceState() {
    }

    @Immutable
    @AutoValue
    public static abstract class Entry {
        public static Entry create(String key, String value) {
            Utils.checkNotNull(key, "key");
            Utils.checkNotNull(value, "value");
            Utils.checkArgument(TraceState.validateKey(key), "Invalid key %s", key);
            Utils.checkArgument(TraceState.validateValue(value), "Invalid value %s", value);
            return new AutoValue_TraceState_Entry(key, value);
        }

        public abstract String getKey();

        public abstract String getValue();

        Entry() {
        }
    }

    public static final class Builder {
        private final TraceState parent;
        @Nullable
        private ArrayList<Entry> entries;
        private static final TraceState EMPTY = TraceState.access$200(Collections.emptyList());

        private Builder(TraceState parent) {
            Utils.checkNotNull(parent, "parent");
            this.parent = parent;
            this.entries = null;
        }

        public Builder set(String key, String value) {
            Entry entry = Entry.create(key, value);
            if (this.entries == null) {
                this.entries = new ArrayList<Entry>(this.parent.getEntries());
            }
            for (int i = 0; i < this.entries.size(); ++i) {
                if (!this.entries.get(i).getKey().equals(entry.getKey())) continue;
                this.entries.remove(i);
                break;
            }
            this.entries.add(0, entry);
            return this;
        }

        public Builder remove(String key) {
            Utils.checkNotNull(key, "key");
            if (this.entries == null) {
                this.entries = new ArrayList<Entry>(this.parent.getEntries());
            }
            for (int i = 0; i < this.entries.size(); ++i) {
                if (!this.entries.get(i).getKey().equals(key)) continue;
                this.entries.remove(i);
                break;
            }
            return this;
        }

        public TraceState build() {
            if (this.entries == null) {
                return this.parent;
            }
            return TraceState.create(this.entries);
        }
    }
}

