/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.correlationcontext;

import io.grpc.Context;
import io.opentelemetry.context.ContextUtils;
import io.opentelemetry.context.Scope;
import io.opentelemetry.correlationcontext.CorrelationContext;
import io.opentelemetry.correlationcontext.EmptyCorrelationContext;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CorrelationsContextUtils {
    private static final Context.Key<CorrelationContext> CORR_CONTEXT_KEY = Context.key((String)"opentelemetry-corr-context-key");

    public static Context withCorrelationContext(CorrelationContext corrContext, Context context) {
        return context.withValue(CORR_CONTEXT_KEY, (Object)corrContext);
    }

    public static CorrelationContext getCurrentCorrelationContext() {
        return CorrelationsContextUtils.getCorrelationContext(Context.current());
    }

    public static CorrelationContext getCorrelationContext(Context context) {
        CorrelationContext corrContext = (CorrelationContext)CORR_CONTEXT_KEY.get(context);
        return corrContext == null ? EmptyCorrelationContext.getInstance() : corrContext;
    }

    @Nullable
    public static CorrelationContext getCorrelationContextWithoutDefault(Context context) {
        return (CorrelationContext)CORR_CONTEXT_KEY.get(context);
    }

    public static Scope currentContextWith(CorrelationContext corrContext) {
        Context context = CorrelationsContextUtils.withCorrelationContext(corrContext, Context.current());
        return ContextUtils.withScopedContext((Context)context);
    }

    private CorrelationsContextUtils() {
    }
}

