/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.internal;

import io.opentelemetry.api.internal.ReadOnlyArrayMap;
import io.opentelemetry.api.internal.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class ImmutableKeyValuePairs<K, V> {
    protected List<Object> data() {
        return Collections.emptyList();
    }

    public int size() {
        return this.data().size() / 2;
    }

    public boolean isEmpty() {
        return this.data().isEmpty();
    }

    public Map<K, V> asMap() {
        return ReadOnlyArrayMap.wrap(this.data());
    }

    @Nullable
    public V get(K key) {
        for (int i = 0; i < this.data().size(); i += 2) {
            if (!key.equals(this.data().get(i))) continue;
            return (V)this.data().get(i + 1);
        }
        return null;
    }

    public static List<Object> sortAndFilter(Object[] data, boolean filterNullValues) {
        Utils.checkArgument(data.length % 2 == 0, "You must provide an even number of key/value pair arguments.");
        ImmutableKeyValuePairs.mergeSort(data);
        return ImmutableKeyValuePairs.dedupe(data, filterNullValues);
    }

    private static void mergeSort(Object[] data) {
        Object[] workArray = new Object[data.length];
        ImmutableKeyValuePairs.mergeSort(data, workArray, data.length);
    }

    private static <K extends Comparable<K>> void mergeSort(Object[] sourceArray, Object[] workArray, int n) {
        System.arraycopy(sourceArray, 0, workArray, 0, sourceArray.length);
        ImmutableKeyValuePairs.splitAndMerge(workArray, 0, n, sourceArray);
    }

    private static <K extends Comparable<K>> void splitAndMerge(Object[] workArray, int beginIndex, int endIndex, Object[] targetArray) {
        if (endIndex - beginIndex <= 2) {
            return;
        }
        int midpoint = (endIndex + beginIndex) / 4 * 2;
        ImmutableKeyValuePairs.splitAndMerge(targetArray, beginIndex, midpoint, workArray);
        ImmutableKeyValuePairs.splitAndMerge(targetArray, midpoint, endIndex, workArray);
        ImmutableKeyValuePairs.merge(workArray, beginIndex, midpoint, endIndex, targetArray);
    }

    private static <K extends Comparable<K>> void merge(Object[] sourceArray, int beginIndex, int middleIndex, int endIndex, Object[] targetArray) {
        int leftKeyIndex = beginIndex;
        int rightKeyIndex = middleIndex;
        for (int k = beginIndex; k < endIndex; k += 2) {
            if (leftKeyIndex < middleIndex - 1 && (rightKeyIndex >= endIndex - 1 || ImmutableKeyValuePairs.compareToNullSafe((Comparable)sourceArray[leftKeyIndex], (Comparable)sourceArray[rightKeyIndex]) <= 0)) {
                targetArray[k] = sourceArray[leftKeyIndex];
                targetArray[k + 1] = sourceArray[leftKeyIndex + 1];
                leftKeyIndex += 2;
                continue;
            }
            targetArray[k] = sourceArray[rightKeyIndex];
            targetArray[k + 1] = sourceArray[rightKeyIndex + 1];
            rightKeyIndex += 2;
        }
    }

    private static <K extends Comparable<K>> int compareToNullSafe(@Nullable K key, @Nullable K pivotKey) {
        if (key == null) {
            return pivotKey == null ? 0 : -1;
        }
        if (pivotKey == null) {
            return 1;
        }
        return key.compareTo(pivotKey);
    }

    private static List<Object> dedupe(Object[] data, boolean filterNullValues) {
        ArrayList<Object> result = new ArrayList<Object>(data.length);
        Object previousKey = null;
        for (int i = data.length - 2; i >= 0; i -= 2) {
            Object key = data[i];
            Object value = data[i + 1];
            if (key == null || key.equals(previousKey)) continue;
            previousKey = key;
            if (filterNullValues && value == null) continue;
            result.add(value);
            result.add(key);
        }
        Collections.reverse(result);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        List<Object> data = this.data();
        for (int i = 0; i < data.size(); i += 2) {
            sb.append(data.get(i)).append("=").append(data.get(i + 1)).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append("}");
        return sb.toString();
    }
}

