/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api;

import io.opentelemetry.api.DefaultOpenTelemetry;
import io.opentelemetry.api.OpenTelemetryBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import java.util.Objects;

public interface OpenTelemetry {
    public static OpenTelemetry get() {
        return DefaultOpenTelemetry.getGlobalOpenTelemetry();
    }

    public static void set(OpenTelemetry openTelemetry) {
        DefaultOpenTelemetry.setGlobalOpenTelemetry(openTelemetry);
    }

    public static TracerProvider getGlobalTracerProvider() {
        return DefaultOpenTelemetry.getGlobalOpenTelemetry().getTracerProvider();
    }

    public static Tracer getGlobalTracer(String instrumentationName) {
        return DefaultOpenTelemetry.getGlobalOpenTelemetry().getTracer(instrumentationName);
    }

    public static Tracer getGlobalTracer(String instrumentationName, String instrumentationVersion) {
        return DefaultOpenTelemetry.getGlobalOpenTelemetry().getTracer(instrumentationName, instrumentationVersion);
    }

    public static MeterProvider getGlobalMeterProvider() {
        return DefaultOpenTelemetry.getGlobalOpenTelemetry().getMeterProvider();
    }

    public static Meter getGlobalMeter(String instrumentationName) {
        return DefaultOpenTelemetry.getGlobalOpenTelemetry().getMeter(instrumentationName);
    }

    public static Meter getGlobalMeter(String instrumentationName, String instrumentationVersion) {
        return DefaultOpenTelemetry.getGlobalOpenTelemetry().getMeter(instrumentationName, instrumentationVersion);
    }

    public static ContextPropagators getGlobalPropagators() {
        return DefaultOpenTelemetry.getGlobalOpenTelemetry().getPropagators();
    }

    public static void setGlobalPropagators(ContextPropagators propagators) {
        Objects.requireNonNull(propagators, "propagators");
        OpenTelemetry.set(OpenTelemetry.get().toBuilder().setPropagators(propagators).build());
    }

    public TracerProvider getTracerProvider();

    default public Tracer getTracer(String instrumentationName) {
        return OpenTelemetry.getGlobalTracerProvider().get(instrumentationName);
    }

    default public Tracer getTracer(String instrumentationName, String instrumentationVersion) {
        return OpenTelemetry.getGlobalTracerProvider().get(instrumentationName, instrumentationVersion);
    }

    public MeterProvider getMeterProvider();

    default public Meter getMeter(String instrumentationName) {
        return OpenTelemetry.getGlobalMeterProvider().get(instrumentationName);
    }

    default public Meter getMeter(String instrumentationName, String instrumentationVersion) {
        return OpenTelemetry.getGlobalMeterProvider().get(instrumentationName, instrumentationVersion);
    }

    public ContextPropagators getPropagators();

    public OpenTelemetryBuilder<?> toBuilder();
}

