/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.trace;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import io.opentelemetry.api.trace.AutoValue_SpanContext;
import io.opentelemetry.api.trace.BigendianEncoding;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.api.trace.TraceState;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class SpanContext {
    private static final SpanContext INVALID = SpanContext.create(TraceId.getInvalid(), SpanId.getInvalid(), TraceFlags.getDefault(), TraceState.getDefault());

    public static SpanContext getInvalid() {
        return INVALID;
    }

    public static SpanContext create(String traceIdHex, String spanIdHex, byte traceFlags, TraceState traceState) {
        return SpanContext.create(traceIdHex, spanIdHex, traceFlags, traceState, false);
    }

    private static SpanContext create(String traceIdHex, String spanIdHex, byte traceFlags, TraceState traceState, boolean remote) {
        return new AutoValue_SpanContext(traceIdHex, spanIdHex, traceFlags, traceState, remote);
    }

    public static SpanContext createFromRemoteParent(String traceIdHex, String spanIdHex, byte traceFlags, TraceState traceState) {
        return SpanContext.create(traceIdHex, spanIdHex, traceFlags, traceState, true);
    }

    abstract String getTraceIdHex();

    abstract String getSpanIdHex();

    public String getTraceIdAsHexString() {
        return this.getTraceIdHex();
    }

    @Memoized
    public byte[] getTraceIdBytes() {
        return TraceId.bytesFromHex(this.getTraceIdHex(), 0);
    }

    public String getSpanIdAsHexString() {
        return this.getSpanIdHex();
    }

    @Memoized
    public byte[] getSpanIdBytes() {
        return SpanId.bytesFromHex(this.getSpanIdHex(), 0);
    }

    public boolean isSampled() {
        return (this.getTraceFlags() & 1) == 1;
    }

    public abstract byte getTraceFlags();

    public void copyTraceFlagsHexTo(char[] dest, int destOffset) {
        BigendianEncoding.byteToBase16String(this.getTraceFlags(), dest, destOffset);
    }

    public abstract TraceState getTraceState();

    @Memoized
    public boolean isValid() {
        return TraceId.isValid(this.getTraceIdHex()) && SpanId.isValid(this.getSpanIdHex());
    }

    public abstract boolean isRemote();
}

