/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.baggage;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageConsumer;
import io.opentelemetry.api.baggage.Entry;
import io.opentelemetry.api.baggage.EntryMetadata;
import io.opentelemetry.context.Context;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
class ImmutableBaggage
implements Baggage {
    static final Baggage EMPTY = new Builder().build();
    private final Map<String, Entry> entries;
    @Nullable
    private final Baggage parent;

    private ImmutableBaggage(Map<String, ? extends Entry> entries, Baggage parent) {
        this.entries = Collections.unmodifiableMap(new HashMap<String, Entry>(Objects.requireNonNull(entries, "entries")));
        this.parent = parent;
    }

    public static Baggage.Builder builder() {
        return new Builder();
    }

    @Override
    public int size() {
        BaggageCounter counter = new BaggageCounter();
        this.forEach(counter);
        return counter.count;
    }

    @Override
    public void forEach(BaggageConsumer consumer) {
        HashSet consumedKeys = new HashSet(this.entries.size());
        this.entries.forEach((? super K key, ? super V entry) -> {
            consumedKeys.add(key);
            if (entry == null) {
                return;
            }
            consumer.accept((String)key, entry.getValue(), entry.getEntryMetadata());
        });
        if (this.parent != null) {
            this.parent.forEach((key, value, metadata) -> {
                if (consumedKeys.add(key)) {
                    consumer.accept(key, value, metadata);
                }
            });
        }
    }

    @Override
    @Nullable
    public String getEntryValue(String entryKey) {
        Entry entry = this.entries.get(entryKey);
        if (entry != null) {
            return entry.getValue();
        }
        return this.parent == null ? null : this.parent.getEntryValue(entryKey);
    }

    @Override
    public Baggage.Builder toBuilder() {
        Builder builder = new Builder();
        builder.entries.putAll(this.entries);
        builder.parent = this.parent;
        builder.noImplicitParent = true;
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableBaggage)) {
            return false;
        }
        ImmutableBaggage baggage = (ImmutableBaggage)o;
        if (!this.entries.equals(baggage.entries)) {
            return false;
        }
        return Objects.equals(this.parent, baggage.parent);
    }

    public int hashCode() {
        int result = this.entries.hashCode();
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ImmutableBaggage{entries=" + this.entries + ", parent=" + this.parent + '}';
    }

    static class Builder
    implements Baggage.Builder {
        @Nullable
        private Baggage parent;
        private boolean noImplicitParent;
        private final Map<String, Entry> entries = new HashMap<String, Entry>();

        Builder() {
        }

        @Override
        public Baggage.Builder setParent(Context context) {
            Objects.requireNonNull(context, "context");
            this.parent = Baggage.fromContext(context);
            return this;
        }

        @Override
        public Baggage.Builder setNoParent() {
            this.parent = null;
            this.noImplicitParent = true;
            return this;
        }

        @Override
        public Baggage.Builder put(String key, String value, EntryMetadata entryMetadata) {
            this.entries.put(Objects.requireNonNull(key, "key"), Entry.create(key, Objects.requireNonNull(value, "value"), Objects.requireNonNull(entryMetadata, "entryMetadata")));
            return this;
        }

        @Override
        public Baggage.Builder put(String key, String value) {
            this.entries.put(Objects.requireNonNull(key, "key"), Entry.create(key, Objects.requireNonNull(value, "value"), EntryMetadata.EMPTY));
            return this;
        }

        @Override
        public Baggage.Builder remove(String key) {
            this.entries.remove(Objects.requireNonNull(key, "key"));
            if (this.parent != null && this.parent.getEntryValue(key) != null) {
                this.entries.put(key, null);
            }
            return this;
        }

        @Override
        public ImmutableBaggage build() {
            if (this.parent == null && !this.noImplicitParent) {
                this.parent = Baggage.current();
            }
            return new ImmutableBaggage(this.entries, this.parent);
        }
    }

    private static class BaggageCounter
    implements BaggageConsumer {
        private int count = 0;

        private BaggageCounter() {
        }

        @Override
        public void accept(String key, String value, EntryMetadata metadata) {
            ++this.count;
        }
    }
}

