/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.trace;

import io.opentelemetry.common.AttributeKey;
import io.opentelemetry.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.trace.EndSpanOptions;
import io.opentelemetry.trace.PropagatedSpan;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.StatusCode;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface Span {
    public static Span getInvalid() {
        return PropagatedSpan.INVALID;
    }

    public static Span wrap(SpanContext spanContext) {
        if (spanContext == null || !spanContext.isValid()) {
            return Span.getInvalid();
        }
        return new PropagatedSpan(spanContext);
    }

    public void setAttribute(String var1, @Nonnull String var2);

    public void setAttribute(String var1, long var2);

    public void setAttribute(String var1, double var2);

    public void setAttribute(String var1, boolean var2);

    public <T> void setAttribute(AttributeKey<T> var1, @Nonnull T var2);

    default public void setAttribute(AttributeKey<Long> key, int value) {
        this.setAttribute(key, Long.valueOf(value));
    }

    public void addEvent(String var1);

    public void addEvent(String var1, long var2);

    public void addEvent(String var1, Attributes var2);

    public void addEvent(String var1, Attributes var2, long var3);

    public void setStatus(StatusCode var1);

    public void setStatus(StatusCode var1, String var2);

    public void recordException(Throwable var1);

    public void recordException(Throwable var1, Attributes var2);

    public void updateName(String var1);

    public void end();

    public void end(EndSpanOptions var1);

    public SpanContext getContext();

    public boolean isRecording();

    public static interface Builder {
        public Builder setParent(Context var1);

        public Builder setNoParent();

        public Builder addLink(SpanContext var1);

        public Builder addLink(SpanContext var1, Attributes var2);

        public Builder setAttribute(String var1, @Nonnull String var2);

        public Builder setAttribute(String var1, long var2);

        public Builder setAttribute(String var1, double var2);

        public Builder setAttribute(String var1, boolean var2);

        public <T> Builder setAttribute(AttributeKey<T> var1, @Nonnull T var2);

        public Builder setSpanKind(Kind var1);

        public Builder setStartTimestamp(long var1);

        public Span startSpan();
    }

    public static enum Kind {
        INTERNAL,
        SERVER,
        CLIENT,
        PRODUCER,
        CONSUMER;

    }
}

