/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.webapp;

import io.opentelemetry.testing.internal.jetty.util.resource.Resource;
import io.opentelemetry.testing.internal.jetty.webapp.AbstractConfiguration;
import io.opentelemetry.testing.internal.jetty.webapp.MetaData;
import io.opentelemetry.testing.internal.jetty.webapp.WebAppContext;
import java.util.Map;

public class FragmentConfiguration
extends AbstractConfiguration {
    public static final String FRAGMENT_RESOURCES = "io.opentelemetry.testing.internal.jetty.webFragments";

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        this.addWebFragments(context, context.getMetaData());
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
        context.setAttribute(FRAGMENT_RESOURCES, null);
    }

    public void findWebFragments(WebAppContext context, MetaData metaData) throws Exception {
        this.addWebFragments(context, metaData);
    }

    public void addWebFragments(WebAppContext context, MetaData metaData) throws Exception {
        Map frags = (Map)context.getAttribute(FRAGMENT_RESOURCES);
        if (frags != null) {
            for (Map.Entry entry : frags.entrySet()) {
                metaData.addFragment((Resource)entry.getKey(), (Resource)entry.getValue());
            }
        }
    }
}

