/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.server.handler;

import io.opentelemetry.testing.internal.jetty.server.Request;
import io.opentelemetry.testing.internal.jetty.server.RequestLog;
import io.opentelemetry.testing.internal.jetty.server.handler.HandlerWrapper;
import io.opentelemetry.testing.internal.servlet.DispatcherType;
import io.opentelemetry.testing.internal.servlet.ServletException;
import io.opentelemetry.testing.internal.servlet.http.HttpServletRequest;
import io.opentelemetry.testing.internal.servlet.http.HttpServletResponse;
import java.io.IOException;

public class RequestLogHandler
extends HandlerWrapper {
    private RequestLog _requestLog;

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (baseRequest.getDispatcherType() == DispatcherType.REQUEST) {
            baseRequest.getHttpChannel().addRequestLog(this._requestLog);
        }
        if (this._handler != null) {
            this._handler.handle(target, baseRequest, request, response);
        }
    }

    public void setRequestLog(RequestLog requestLog) {
        this.updateBean(this._requestLog, requestLog);
        this._requestLog = requestLog;
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }
}

