/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.server;

import io.opentelemetry.testing.internal.jetty.io.ByteBufferPool;
import io.opentelemetry.testing.internal.jetty.io.ChannelEndPoint;
import io.opentelemetry.testing.internal.jetty.io.ManagedSelector;
import io.opentelemetry.testing.internal.jetty.io.NetworkTrafficListener;
import io.opentelemetry.testing.internal.jetty.io.NetworkTrafficSocketChannelEndPoint;
import io.opentelemetry.testing.internal.jetty.server.ConnectionFactory;
import io.opentelemetry.testing.internal.jetty.server.HttpConnectionFactory;
import io.opentelemetry.testing.internal.jetty.server.Server;
import io.opentelemetry.testing.internal.jetty.server.ServerConnector;
import io.opentelemetry.testing.internal.jetty.util.ssl.SslContextFactory;
import io.opentelemetry.testing.internal.jetty.util.thread.Scheduler;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;

public class NetworkTrafficServerConnector
extends ServerConnector {
    private final List<NetworkTrafficListener> listeners = new CopyOnWriteArrayList<NetworkTrafficListener>();

    public NetworkTrafficServerConnector(Server server) {
        this(server, null, null, null, 0, 0, new HttpConnectionFactory());
    }

    public NetworkTrafficServerConnector(Server server, ConnectionFactory connectionFactory, SslContextFactory sslContextFactory) {
        super(server, sslContextFactory, connectionFactory);
    }

    public NetworkTrafficServerConnector(Server server, ConnectionFactory connectionFactory) {
        super(server, connectionFactory);
    }

    public NetworkTrafficServerConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool pool, int acceptors, int selectors, ConnectionFactory ... factories) {
        super(server, executor, scheduler, pool, acceptors, selectors, factories);
    }

    public NetworkTrafficServerConnector(Server server, SslContextFactory sslContextFactory) {
        super(server, sslContextFactory);
    }

    public void addNetworkTrafficListener(NetworkTrafficListener listener) {
        this.listeners.add(listener);
    }

    public void removeNetworkTrafficListener(NetworkTrafficListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    protected ChannelEndPoint newEndPoint(SocketChannel channel, ManagedSelector selectSet, SelectionKey key) {
        return new NetworkTrafficSocketChannelEndPoint(channel, selectSet, key, this.getScheduler(), this.getIdleTimeout(), this.listeners);
    }
}

