/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.server;

import io.opentelemetry.testing.internal.jetty.server.MultiParts;
import io.opentelemetry.testing.internal.jetty.server.handler.ContextHandler;
import io.opentelemetry.testing.internal.servlet.ServletRequestEvent;
import io.opentelemetry.testing.internal.servlet.ServletRequestListener;

public class MultiPartCleanerListener
implements ServletRequestListener {
    public static final MultiPartCleanerListener INSTANCE = new MultiPartCleanerListener();

    protected MultiPartCleanerListener() {
    }

    @Override
    public void requestDestroyed(ServletRequestEvent sre) {
        ContextHandler.Context context;
        MultiParts parts = (MultiParts)sre.getServletRequest().getAttribute("io.opentelemetry.testing.internal.jetty.multiParts");
        if (parts != null && (context = parts.getContext()) == sre.getServletContext()) {
            try {
                parts.close();
            }
            catch (Throwable e) {
                sre.getServletContext().log("Errors deleting multipart tmp files", e);
            }
        }
    }

    @Override
    public void requestInitialized(ServletRequestEvent sre) {
    }
}

