/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.server;

import io.opentelemetry.testing.internal.jetty.server.Connector;
import io.opentelemetry.testing.internal.jetty.server.HttpConfiguration;
import io.opentelemetry.testing.internal.jetty.server.Request;
import java.util.Objects;

public class HostHeaderCustomizer
implements HttpConfiguration.Customizer {
    private final String serverName;
    private final int serverPort;

    public HostHeaderCustomizer(String serverName) {
        this(serverName, 0);
    }

    public HostHeaderCustomizer(String serverName, int serverPort) {
        this.serverName = Objects.requireNonNull(serverName);
        this.serverPort = serverPort;
    }

    @Override
    public void customize(Connector connector, HttpConfiguration channelConfig, Request request) {
        if (request.getHeader("Host") == null) {
            request.setAuthority(this.serverName, this.serverPort);
        }
    }
}

