/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.security;

import io.opentelemetry.testing.internal.jetty.security.AbstractLoginService;
import io.opentelemetry.testing.internal.jetty.security.DefaultIdentityService;
import io.opentelemetry.testing.internal.jetty.security.IdentityService;
import io.opentelemetry.testing.internal.jetty.server.UserIdentity;
import io.opentelemetry.testing.internal.jetty.util.component.AbstractLifeCycle;
import io.opentelemetry.testing.internal.jetty.util.security.Credential;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;

public class UserStore
extends AbstractLifeCycle {
    private IdentityService _identityService = new DefaultIdentityService();
    private final Map<String, UserIdentity> _knownUserIdentities = new ConcurrentHashMap<String, UserIdentity>();

    public void addUser(String username, Credential credential, String[] roles) {
        AbstractLoginService.UserPrincipal userPrincipal = new AbstractLoginService.UserPrincipal(username, credential);
        Subject subject = new Subject();
        subject.getPrincipals().add(userPrincipal);
        subject.getPrivateCredentials().add(credential);
        if (roles != null) {
            for (String role : roles) {
                subject.getPrincipals().add(new AbstractLoginService.RolePrincipal(role));
            }
        }
        subject.setReadOnly();
        this._knownUserIdentities.put(username, this._identityService.newUserIdentity(subject, userPrincipal, roles));
    }

    public void removeUser(String username) {
        this._knownUserIdentities.remove(username);
    }

    public UserIdentity getUserIdentity(String userName) {
        return this._knownUserIdentities.get(userName);
    }

    public IdentityService getIdentityService() {
        return this._identityService;
    }

    public Map<String, UserIdentity> getKnownUserIdentities() {
        return this._knownUserIdentities;
    }
}

