/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.http2.server;

import io.opentelemetry.testing.internal.jetty.http2.api.Session;
import io.opentelemetry.testing.internal.jetty.http2.api.Stream;
import io.opentelemetry.testing.internal.jetty.http2.api.server.ServerSessionListener;
import io.opentelemetry.testing.internal.jetty.http2.frames.GoAwayFrame;
import io.opentelemetry.testing.internal.jetty.http2.frames.HeadersFrame;
import io.opentelemetry.testing.internal.jetty.http2.frames.PingFrame;
import io.opentelemetry.testing.internal.jetty.http2.frames.ResetFrame;
import io.opentelemetry.testing.internal.jetty.http2.frames.SettingsFrame;
import io.opentelemetry.testing.internal.jetty.http2.server.AbstractHTTP2ServerConnectionFactory;
import io.opentelemetry.testing.internal.jetty.io.EndPoint;
import io.opentelemetry.testing.internal.jetty.server.Connector;
import io.opentelemetry.testing.internal.jetty.server.HttpConfiguration;
import java.util.Map;
import java.util.Objects;

public class RawHTTP2ServerConnectionFactory
extends AbstractHTTP2ServerConnectionFactory {
    private final ServerSessionListener listener;

    public RawHTTP2ServerConnectionFactory(HttpConfiguration httpConfiguration, ServerSessionListener listener) {
        super(httpConfiguration);
        this.listener = new RawServerSessionListener(Objects.requireNonNull(listener));
    }

    public RawHTTP2ServerConnectionFactory(HttpConfiguration httpConfiguration, ServerSessionListener listener, String ... protocols) {
        super(httpConfiguration, protocols);
        this.listener = listener;
    }

    @Override
    protected ServerSessionListener newSessionListener(Connector connector, EndPoint endPoint) {
        return this.listener;
    }

    private class RawServerSessionListener
    implements ServerSessionListener {
        private final ServerSessionListener delegate;

        private RawServerSessionListener(ServerSessionListener delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onAccept(Session session) {
            this.delegate.onAccept(session);
        }

        @Override
        public Map<Integer, Integer> onPreface(Session session) {
            Map<Integer, Integer> settings = RawHTTP2ServerConnectionFactory.this.newSettings();
            Map<Integer, Integer> moreSettings = this.delegate.onPreface(session);
            if (moreSettings != null) {
                settings.putAll(moreSettings);
            }
            return settings;
        }

        @Override
        public Stream.Listener onNewStream(Stream stream, HeadersFrame frame) {
            return this.delegate.onNewStream(stream, frame);
        }

        @Override
        public void onSettings(Session session, SettingsFrame frame) {
            this.delegate.onSettings(session, frame);
        }

        @Override
        public void onPing(Session session, PingFrame frame) {
            this.delegate.onPing(session, frame);
        }

        @Override
        public void onReset(Session session, ResetFrame frame) {
            this.delegate.onReset(session, frame);
        }

        @Override
        public void onGoAway(Session session, GoAwayFrame frame) {
            this.delegate.onGoAway(session, frame);
        }

        @Override
        public void onClose(Session session, GoAwayFrame frame) {
            this.delegate.onClose(session, frame);
        }

        @Override
        public boolean onIdleTimeout(Session session) {
            return this.delegate.onIdleTimeout(session);
        }

        @Override
        public void onFailure(Session session, Throwable failure) {
            this.delegate.onFailure(session, failure);
        }
    }
}

