/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.http2.server;

import io.opentelemetry.testing.internal.jetty.http.MetaData;
import io.opentelemetry.testing.internal.jetty.http2.CloseState;
import io.opentelemetry.testing.internal.jetty.http2.ErrorCode;
import io.opentelemetry.testing.internal.jetty.http2.FlowControlStrategy;
import io.opentelemetry.testing.internal.jetty.http2.HTTP2Session;
import io.opentelemetry.testing.internal.jetty.http2.IStream;
import io.opentelemetry.testing.internal.jetty.http2.api.Session;
import io.opentelemetry.testing.internal.jetty.http2.api.Stream;
import io.opentelemetry.testing.internal.jetty.http2.api.server.ServerSessionListener;
import io.opentelemetry.testing.internal.jetty.http2.frames.Frame;
import io.opentelemetry.testing.internal.jetty.http2.frames.HeadersFrame;
import io.opentelemetry.testing.internal.jetty.http2.frames.PushPromiseFrame;
import io.opentelemetry.testing.internal.jetty.http2.frames.SettingsFrame;
import io.opentelemetry.testing.internal.jetty.http2.frames.WindowUpdateFrame;
import io.opentelemetry.testing.internal.jetty.http2.generator.Generator;
import io.opentelemetry.testing.internal.jetty.http2.parser.ServerParser;
import io.opentelemetry.testing.internal.jetty.io.EndPoint;
import io.opentelemetry.testing.internal.jetty.util.Callback;
import io.opentelemetry.testing.internal.jetty.util.log.Log;
import io.opentelemetry.testing.internal.jetty.util.log.Logger;
import io.opentelemetry.testing.internal.jetty.util.thread.Scheduler;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

public class HTTP2ServerSession
extends HTTP2Session
implements ServerParser.Listener {
    private static final Logger LOG = Log.getLogger(HTTP2ServerSession.class);
    private final ServerSessionListener listener;

    public HTTP2ServerSession(Scheduler scheduler, EndPoint endPoint, Generator generator, ServerSessionListener listener, FlowControlStrategy flowControl) {
        super(scheduler, endPoint, generator, listener, flowControl, 2);
        this.listener = listener;
    }

    @Override
    public void onPreface() {
        Map<Integer, Integer> settings = this.notifyPreface(this);
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        SettingsFrame settingsFrame = new SettingsFrame(settings, false);
        int sessionWindow = this.getInitialSessionRecvWindow() - 65535;
        this.updateRecvWindow(sessionWindow);
        if (sessionWindow > 0) {
            this.frames(null, Arrays.asList(settingsFrame, new WindowUpdateFrame(0, sessionWindow)), Callback.NOOP);
        } else {
            this.frames(null, Collections.singletonList(settingsFrame), Callback.NOOP);
        }
    }

    @Override
    public void onHeaders(HeadersFrame frame) {
        int streamId;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received {}", frame);
        }
        if (!HTTP2ServerSession.isClientStream(streamId = frame.getStreamId())) {
            this.onConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "invalid_stream_id");
            return;
        }
        IStream stream = this.getStream(streamId);
        MetaData metaData = frame.getMetaData();
        if (metaData.isRequest()) {
            if (stream == null) {
                if (this.isRemoteStreamClosed(streamId)) {
                    this.onConnectionFailure(ErrorCode.STREAM_CLOSED_ERROR.code, "unexpected_headers_frame");
                } else {
                    stream = this.createRemoteStream(streamId);
                    if (stream != null) {
                        this.onStreamOpened(stream);
                        stream.process(frame, Callback.NOOP);
                        if (stream.updateClose(frame.isEndStream(), CloseState.Event.RECEIVED)) {
                            this.removeStream(stream);
                        }
                        Stream.Listener listener = this.notifyNewStream(stream, frame);
                        stream.setListener(listener);
                    }
                }
            } else {
                this.onConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "duplicate_stream");
            }
        } else if (metaData.isResponse()) {
            this.onConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "invalid_request");
        } else if (stream != null) {
            stream.process(frame, Callback.NOOP);
            if (stream.updateClose(frame.isEndStream(), CloseState.Event.RECEIVED)) {
                this.removeStream(stream);
            }
            this.notifyHeaders(stream, frame);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stream #{} not found", streamId);
            }
            this.onConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "unexpected_headers_frame");
        }
    }

    @Override
    public void onPushPromise(PushPromiseFrame frame) {
        this.onConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "push_promise");
    }

    private Map<Integer, Integer> notifyPreface(Session session) {
        try {
            return this.listener.onPreface(session);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
            return null;
        }
    }

    @Override
    public void onFrame(Frame frame) {
        switch (frame.getType()) {
            case PREFACE: {
                this.onPreface();
                break;
            }
            case SETTINGS: {
                this.onSettings((SettingsFrame)frame, false);
                break;
            }
            case HEADERS: {
                this.onHeaders((HeadersFrame)frame);
                break;
            }
            default: {
                super.onFrame(frame);
            }
        }
    }
}

