/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.http2.server;

import io.opentelemetry.testing.internal.jetty.http2.BufferingFlowControlStrategy;
import io.opentelemetry.testing.internal.jetty.http2.FlowControlStrategy;
import io.opentelemetry.testing.internal.jetty.http2.HTTP2Connection;
import io.opentelemetry.testing.internal.jetty.http2.ISession;
import io.opentelemetry.testing.internal.jetty.http2.api.Session;
import io.opentelemetry.testing.internal.jetty.http2.api.server.ServerSessionListener;
import io.opentelemetry.testing.internal.jetty.http2.generator.Generator;
import io.opentelemetry.testing.internal.jetty.http2.parser.RateControl;
import io.opentelemetry.testing.internal.jetty.http2.parser.ServerParser;
import io.opentelemetry.testing.internal.jetty.http2.parser.WindowRateControl;
import io.opentelemetry.testing.internal.jetty.http2.server.HTTP2ServerConnection;
import io.opentelemetry.testing.internal.jetty.http2.server.HTTP2ServerSession;
import io.opentelemetry.testing.internal.jetty.io.Connection;
import io.opentelemetry.testing.internal.jetty.io.EndPoint;
import io.opentelemetry.testing.internal.jetty.server.AbstractConnectionFactory;
import io.opentelemetry.testing.internal.jetty.server.Connector;
import io.opentelemetry.testing.internal.jetty.server.HttpConfiguration;
import io.opentelemetry.testing.internal.jetty.util.annotation.ManagedAttribute;
import io.opentelemetry.testing.internal.jetty.util.annotation.ManagedObject;
import io.opentelemetry.testing.internal.jetty.util.annotation.Name;
import io.opentelemetry.testing.internal.jetty.util.component.Dumpable;
import io.opentelemetry.testing.internal.jetty.util.component.LifeCycle;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@ManagedObject
public abstract class AbstractHTTP2ServerConnectionFactory
extends AbstractConnectionFactory {
    private final HTTP2SessionContainer sessionContainer = new HTTP2SessionContainer();
    private final HttpConfiguration httpConfiguration;
    private int maxDynamicTableSize = 4096;
    private int initialSessionRecvWindow = 0x100000;
    private int initialStreamRecvWindow = 524288;
    private int maxConcurrentStreams = 128;
    private int maxHeaderBlockFragment = 0;
    private int maxFrameLength = 16384;
    private int maxSettingsKeys = 64;
    private RateControl.Factory rateControlFactory = new WindowRateControl.Factory(50);
    private FlowControlStrategy.Factory flowControlStrategyFactory = () -> new BufferingFlowControlStrategy(0.5f);
    private long streamIdleTimeout;

    public AbstractHTTP2ServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration) {
        this(httpConfiguration, "h2");
    }

    protected AbstractHTTP2ServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration, String ... protocols) {
        super(protocols);
        for (String p : protocols) {
            if (HTTP2ServerConnection.isSupportedProtocol(p)) continue;
            throw new IllegalArgumentException("Unsupported HTTP2 Protocol variant: " + p);
        }
        this.addBean(this.sessionContainer);
        this.httpConfiguration = Objects.requireNonNull(httpConfiguration);
        this.addBean(httpConfiguration);
        this.setInputBufferSize(16393);
    }

    @ManagedAttribute(value="The HPACK dynamic table maximum size")
    public int getMaxDynamicTableSize() {
        return this.maxDynamicTableSize;
    }

    public void setMaxDynamicTableSize(int maxDynamicTableSize) {
        this.maxDynamicTableSize = maxDynamicTableSize;
    }

    @ManagedAttribute(value="The initial size of session's flow control receive window")
    public int getInitialSessionRecvWindow() {
        return this.initialSessionRecvWindow;
    }

    public void setInitialSessionRecvWindow(int initialSessionRecvWindow) {
        this.initialSessionRecvWindow = initialSessionRecvWindow;
    }

    @ManagedAttribute(value="The initial size of stream's flow control receive window")
    public int getInitialStreamRecvWindow() {
        return this.initialStreamRecvWindow;
    }

    public void setInitialStreamRecvWindow(int initialStreamRecvWindow) {
        this.initialStreamRecvWindow = initialStreamRecvWindow;
    }

    @ManagedAttribute(value="The max number of concurrent streams per session")
    public int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public void setMaxConcurrentStreams(int maxConcurrentStreams) {
        this.maxConcurrentStreams = maxConcurrentStreams;
    }

    @ManagedAttribute(value="The max header block fragment")
    public int getMaxHeaderBlockFragment() {
        return this.maxHeaderBlockFragment;
    }

    public void setMaxHeaderBlockFragment(int maxHeaderBlockFragment) {
        this.maxHeaderBlockFragment = maxHeaderBlockFragment;
    }

    public FlowControlStrategy.Factory getFlowControlStrategyFactory() {
        return this.flowControlStrategyFactory;
    }

    public void setFlowControlStrategyFactory(FlowControlStrategy.Factory flowControlStrategyFactory) {
        this.flowControlStrategyFactory = flowControlStrategyFactory;
    }

    @ManagedAttribute(value="The stream idle timeout in milliseconds")
    public long getStreamIdleTimeout() {
        return this.streamIdleTimeout;
    }

    public void setStreamIdleTimeout(long streamIdleTimeout) {
        this.streamIdleTimeout = streamIdleTimeout;
    }

    @ManagedAttribute(value="The max frame length in bytes")
    public int getMaxFrameLength() {
        return this.maxFrameLength;
    }

    public void setMaxFrameLength(int maxFrameLength) {
        this.maxFrameLength = maxFrameLength;
    }

    @ManagedAttribute(value="The max number of keys in all SETTINGS frames")
    public int getMaxSettingsKeys() {
        return this.maxSettingsKeys;
    }

    public void setMaxSettingsKeys(int maxSettingsKeys) {
        this.maxSettingsKeys = maxSettingsKeys;
    }

    @Deprecated
    public RateControl getRateControl() {
        return null;
    }

    @Deprecated
    public void setRateControl(RateControl rateControl) {
        if (rateControl.getClass() != WindowRateControl.class) {
            throw new UnsupportedOperationException();
        }
        this.setRateControlFactory(new WindowRateControl.Factory(((WindowRateControl)rateControl).getEventsPerSecond()));
    }

    public RateControl.Factory getRateControlFactory() {
        return this.rateControlFactory;
    }

    public void setRateControlFactory(RateControl.Factory rateControlFactory) {
        this.rateControlFactory = Objects.requireNonNull(rateControlFactory);
    }

    @Deprecated
    public int getReservedThreads() {
        return -1;
    }

    @Deprecated
    public void setReservedThreads(int threads) {
        throw new UnsupportedOperationException();
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    protected Map<Integer, Integer> newSettings() {
        HashMap<Integer, Integer> settings = new HashMap<Integer, Integer>();
        settings.put(1, this.getMaxDynamicTableSize());
        settings.put(4, this.getInitialStreamRecvWindow());
        int maxConcurrentStreams = this.getMaxConcurrentStreams();
        if (maxConcurrentStreams >= 0) {
            settings.put(3, maxConcurrentStreams);
        }
        settings.put(6, this.getHttpConfiguration().getRequestHeaderSize());
        return settings;
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        ServerSessionListener listener = this.newSessionListener(connector, endPoint);
        Generator generator = new Generator(connector.getByteBufferPool(), this.getMaxDynamicTableSize(), this.getMaxHeaderBlockFragment());
        FlowControlStrategy flowControl = this.getFlowControlStrategyFactory().newFlowControlStrategy();
        HTTP2ServerSession session = new HTTP2ServerSession(connector.getScheduler(), endPoint, generator, listener, flowControl);
        session.setMaxLocalStreams(this.getMaxConcurrentStreams());
        session.setMaxRemoteStreams(this.getMaxConcurrentStreams());
        long streamIdleTimeout = this.getStreamIdleTimeout();
        if (streamIdleTimeout <= 0L) {
            streamIdleTimeout = endPoint.getIdleTimeout();
        }
        session.setStreamIdleTimeout(streamIdleTimeout);
        session.setInitialSessionRecvWindow(this.getInitialSessionRecvWindow());
        session.setWriteThreshold(this.getHttpConfiguration().getOutputBufferSize());
        ServerParser parser = this.newServerParser(connector, session, this.getRateControlFactory().newRateControl(endPoint));
        parser.setMaxFrameLength(this.getMaxFrameLength());
        parser.setMaxSettingsKeys(this.getMaxSettingsKeys());
        HTTP2ServerConnection connection = new HTTP2ServerConnection(connector.getByteBufferPool(), connector.getExecutor(), endPoint, this.httpConfiguration, parser, session, this.getInputBufferSize(), listener);
        connection.addListener(this.sessionContainer);
        return this.configure(connection, connector, endPoint);
    }

    protected abstract ServerSessionListener newSessionListener(Connector var1, EndPoint var2);

    protected ServerParser newServerParser(Connector connector, ServerParser.Listener listener, RateControl rateControl) {
        return new ServerParser(connector.getByteBufferPool(), listener, this.getMaxDynamicTableSize(), this.getHttpConfiguration().getRequestHeaderSize(), rateControl);
    }

    @ManagedObject(value="The container of HTTP/2 sessions")
    public static class HTTP2SessionContainer
    implements Connection.Listener,
    Dumpable {
        private final Set<Session> sessions = ConcurrentHashMap.newKeySet();

        @Override
        public void onOpened(Connection connection) {
            ISession session = ((HTTP2Connection)connection).getSession();
            this.sessions.add(session);
            LifeCycle.start(session);
        }

        @Override
        public void onClosed(Connection connection) {
            ISession session = ((HTTP2Connection)connection).getSession();
            if (this.sessions.remove(session)) {
                LifeCycle.stop(session);
            }
        }

        public Set<Session> getSessions() {
            return new HashSet<Session>(this.sessions);
        }

        @ManagedAttribute(value="The number of HTTP/2 sessions", readonly=true)
        public int getSize() {
            return this.sessions.size();
        }

        @Override
        public String dump() {
            return Dumpable.dump(this);
        }

        @Override
        public void dump(Appendable out, String indent) throws IOException {
            Dumpable.dumpObjects(out, indent, this, this.sessions);
        }

        public String toString() {
            return String.format("%s@%x[size=%d]", this.getClass().getSimpleName(), this.hashCode(), this.getSize());
        }
    }
}

