/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.client;

import io.opentelemetry.testing.internal.jetty.client.DuplexConnectionPool;
import io.opentelemetry.testing.internal.jetty.client.HttpDestination;
import io.opentelemetry.testing.internal.jetty.client.api.Connection;
import io.opentelemetry.testing.internal.jetty.client.api.Destination;
import io.opentelemetry.testing.internal.jetty.util.Callback;
import io.opentelemetry.testing.internal.jetty.util.LeakDetector;
import io.opentelemetry.testing.internal.jetty.util.component.LifeCycle;
import io.opentelemetry.testing.internal.jetty.util.log.Log;
import io.opentelemetry.testing.internal.jetty.util.log.Logger;

public class LeakTrackingConnectionPool
extends DuplexConnectionPool {
    private static final Logger LOG = Log.getLogger(LeakTrackingConnectionPool.class);
    private final LeakDetector<Connection> leakDetector = new LeakDetector<Connection>(){

        @Override
        protected void leaked(LeakDetector.LeakInfo leakInfo) {
            LeakTrackingConnectionPool.this.leaked(leakInfo);
        }
    };

    public LeakTrackingConnectionPool(Destination destination, int maxConnections, Callback requester) {
        super((HttpDestination)destination, maxConnections, requester);
        this.addBean(this.leakDetector);
    }

    @Override
    public void close() {
        LifeCycle.stop(this);
        super.close();
    }

    @Override
    protected void acquired(Connection connection) {
        if (!this.leakDetector.acquired(connection)) {
            LOG.info("Connection {}@{} not tracked", connection, this.leakDetector.id(connection));
        }
    }

    @Override
    protected void released(Connection connection) {
        if (!this.leakDetector.released(connection)) {
            LOG.info("Connection {}@{} released but not acquired", connection, this.leakDetector.id(connection));
        }
    }

    protected void leaked(LeakDetector.LeakInfo leakInfo) {
        LOG.info("Connection " + leakInfo.getResourceDescription() + " leaked at:", leakInfo.getStackFrames());
    }
}

