/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.alpn.server;

import io.opentelemetry.testing.internal.jetty.io.EndPoint;
import io.opentelemetry.testing.internal.jetty.server.ConnectionFactory;
import io.opentelemetry.testing.internal.jetty.server.Connector;
import io.opentelemetry.testing.internal.jetty.server.NegotiatingServerConnection;
import io.opentelemetry.testing.internal.jetty.util.log.Log;
import io.opentelemetry.testing.internal.jetty.util.log.Logger;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;

public class ALPNServerConnection
extends NegotiatingServerConnection {
    private static final Logger LOG = Log.getLogger(ALPNServerConnection.class);

    public ALPNServerConnection(Connector connector, EndPoint endPoint, SSLEngine engine, List<String> protocols, String defaultProtocol) {
        super(connector, endPoint, engine, protocols, defaultProtocol);
    }

    public void unsupported() {
        this.select(Collections.emptyList());
    }

    public void select(List<String> clientProtocols) {
        SSLEngine sslEngine = this.getSSLEngine();
        List<String> serverProtocols = this.getProtocols();
        SSLSession sslSession = sslEngine.getHandshakeSession();
        if (sslSession == null) {
            sslSession = sslEngine.getSession();
        }
        String tlsProtocol = sslSession.getProtocol();
        String tlsCipher = sslSession.getCipherSuite();
        String negotiated = null;
        for (String serverProtocol : serverProtocols) {
            if (!clientProtocols.contains(serverProtocol)) continue;
            ConnectionFactory factory = this.getConnector().getConnectionFactory(serverProtocol);
            if (factory instanceof NegotiatingServerConnection.CipherDiscriminator && !((NegotiatingServerConnection.CipherDiscriminator)((Object)factory)).isAcceptable(serverProtocol, tlsProtocol, tlsCipher)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Protocol {} not acceptable to {} for {}/{} on {}", serverProtocol, factory, tlsProtocol, tlsCipher, this.getEndPoint());
                continue;
            }
            negotiated = serverProtocol;
            break;
        }
        if (negotiated == null) {
            if (clientProtocols.isEmpty()) {
                negotiated = this.getDefaultProtocol();
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not negotiate protocol from client{} and server{} on {}", clientProtocols, serverProtocols, this.getEndPoint());
                }
                throw new IllegalStateException();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Protocol selected {} from client{} and server{} on {}", negotiated, clientProtocols, serverProtocols, this.getEndPoint());
        }
        this.setProtocol(negotiated);
    }
}

