/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.io.netty.handler.codec.socksx.v5;

import io.opentelemetry.testing.internal.io.netty.buffer.ByteBuf;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufUtil;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandler;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.testing.internal.io.netty.handler.codec.EncoderException;
import io.opentelemetry.testing.internal.io.netty.handler.codec.MessageToByteEncoder;
import io.opentelemetry.testing.internal.io.netty.handler.codec.socksx.v5.Socks5AddressEncoder;
import io.opentelemetry.testing.internal.io.netty.handler.codec.socksx.v5.Socks5AddressType;
import io.opentelemetry.testing.internal.io.netty.handler.codec.socksx.v5.Socks5AuthMethod;
import io.opentelemetry.testing.internal.io.netty.handler.codec.socksx.v5.Socks5CommandRequest;
import io.opentelemetry.testing.internal.io.netty.handler.codec.socksx.v5.Socks5InitialRequest;
import io.opentelemetry.testing.internal.io.netty.handler.codec.socksx.v5.Socks5Message;
import io.opentelemetry.testing.internal.io.netty.handler.codec.socksx.v5.Socks5PasswordAuthRequest;
import io.opentelemetry.testing.internal.io.netty.handler.codec.socksx.v5.Socks5PrivateAuthRequest;
import io.opentelemetry.testing.internal.io.netty.util.internal.ObjectUtil;
import io.opentelemetry.testing.internal.io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.RandomAccess;

@ChannelHandler.Sharable
public class Socks5ClientEncoder
extends MessageToByteEncoder<Socks5Message> {
    public static final Socks5ClientEncoder DEFAULT = new Socks5ClientEncoder();
    private final Socks5AddressEncoder addressEncoder;

    protected Socks5ClientEncoder() {
        this(Socks5AddressEncoder.DEFAULT);
    }

    public Socks5ClientEncoder(Socks5AddressEncoder addressEncoder) {
        super(Socks5Message.class);
        this.addressEncoder = ObjectUtil.checkNotNull(addressEncoder, "addressEncoder");
    }

    protected final Socks5AddressEncoder addressEncoder() {
        return this.addressEncoder;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, Socks5Message msg, ByteBuf out) throws Exception {
        if (msg instanceof Socks5InitialRequest) {
            Socks5ClientEncoder.encodeAuthMethodRequest((Socks5InitialRequest)msg, out);
        } else if (msg instanceof Socks5PasswordAuthRequest) {
            Socks5ClientEncoder.encodePasswordAuthRequest((Socks5PasswordAuthRequest)msg, out);
        } else if (msg instanceof Socks5PrivateAuthRequest) {
            Socks5ClientEncoder.encodePrivateAuthRequest((Socks5PrivateAuthRequest)msg, out);
        } else if (msg instanceof Socks5CommandRequest) {
            this.encodeCommandRequest((Socks5CommandRequest)msg, out);
        } else {
            throw new EncoderException("unsupported message type: " + StringUtil.simpleClassName(msg));
        }
    }

    private static void encodeAuthMethodRequest(Socks5InitialRequest msg, ByteBuf out) {
        out.writeByte(msg.version().byteValue());
        List<Socks5AuthMethod> authMethods = msg.authMethods();
        int numAuthMethods = authMethods.size();
        out.writeByte(numAuthMethods);
        if (authMethods instanceof RandomAccess) {
            for (int i = 0; i < numAuthMethods; ++i) {
                out.writeByte(authMethods.get(i).byteValue());
            }
        } else {
            for (Socks5AuthMethod a : authMethods) {
                out.writeByte(a.byteValue());
            }
        }
    }

    private static void encodePasswordAuthRequest(Socks5PasswordAuthRequest msg, ByteBuf out) {
        out.writeByte(1);
        String username = msg.username();
        out.writeByte(username.length());
        ByteBufUtil.writeAscii(out, (CharSequence)username);
        String password = msg.password();
        out.writeByte(password.length());
        ByteBufUtil.writeAscii(out, (CharSequence)password);
    }

    private static void encodePrivateAuthRequest(Socks5PrivateAuthRequest msg, ByteBuf out) {
        byte[] bytes = msg.privateToken();
        out.writeByte(1);
        out.writeByte(bytes.length);
        out.writeBytes(bytes);
    }

    private void encodeCommandRequest(Socks5CommandRequest msg, ByteBuf out) throws Exception {
        out.writeByte(msg.version().byteValue());
        out.writeByte(msg.type().byteValue());
        out.writeByte(0);
        Socks5AddressType dstAddrType = msg.dstAddrType();
        out.writeByte(dstAddrType.byteValue());
        this.addressEncoder.encodeAddress(dstAddrType, msg.dstAddr(), out);
        ByteBufUtil.writeShortBE(out, msg.dstPort());
    }
}

