/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.io.micrometer.core.instrument.distribution;

import io.opentelemetry.testing.internal.io.micrometer.core.instrument.Clock;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.distribution.AbstractTimeWindowHistogram;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.distribution.CountAtBucket;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.opentelemetry.testing.internal.org.hdrhistogram.DoubleHistogram;
import io.opentelemetry.testing.internal.org.hdrhistogram.DoubleRecorder;
import java.io.PrintStream;
import java.util.NavigableSet;
import java.util.Objects;

public class TimeWindowPercentileHistogram
extends AbstractTimeWindowHistogram<DoubleRecorder, DoubleHistogram> {
    private final DoubleHistogram intervalHistogram;
    private final double[] histogramBuckets;
    private final boolean isCumulativeBucketCounts;

    public TimeWindowPercentileHistogram(Clock clock, DistributionStatisticConfig distributionStatisticConfig, boolean supportsAggregablePercentiles) {
        this(clock, distributionStatisticConfig, supportsAggregablePercentiles, true, false);
    }

    protected TimeWindowPercentileHistogram(Clock clock, DistributionStatisticConfig distributionStatisticConfig, boolean supportsAggregablePercentiles, boolean isCumulativeBucketCounts, boolean includeInfinityBucket) {
        super(clock, distributionStatisticConfig, DoubleRecorder.class);
        this.intervalHistogram = new DoubleHistogram(this.percentilePrecision(distributionStatisticConfig));
        this.isCumulativeBucketCounts = isCumulativeBucketCounts;
        NavigableSet<Double> monitoredBuckets = distributionStatisticConfig.getHistogramBuckets(supportsAggregablePercentiles);
        if (includeInfinityBucket) {
            monitoredBuckets.add(Double.POSITIVE_INFINITY);
        }
        this.histogramBuckets = monitoredBuckets.stream().filter(Objects::nonNull).mapToDouble(Double::doubleValue).toArray();
        this.initRingBuffer();
    }

    @Override
    DoubleRecorder newBucket() {
        return new DoubleRecorder(this.percentilePrecision(this.distributionStatisticConfig));
    }

    @Override
    void recordDouble(DoubleRecorder bucket, double value) {
        bucket.recordValue(value);
    }

    @Override
    void recordLong(DoubleRecorder bucket, long value) {
        bucket.recordValue(value);
    }

    @Override
    void resetBucket(DoubleRecorder bucket) {
        bucket.reset();
    }

    DoubleHistogram newAccumulatedHistogram(DoubleRecorder[] ringBuffer) {
        return new DoubleHistogram(this.percentilePrecision(this.distributionStatisticConfig));
    }

    @Override
    void accumulate() {
        ((DoubleRecorder)this.currentHistogram()).getIntervalHistogramInto(this.intervalHistogram);
        ((DoubleHistogram)this.accumulatedHistogram()).add(this.intervalHistogram);
    }

    @Override
    void resetAccumulatedHistogram() {
        ((DoubleHistogram)this.accumulatedHistogram()).reset();
    }

    @Override
    double valueAtPercentile(double percentile) {
        return ((DoubleHistogram)this.accumulatedHistogram()).getValueAtPercentile(percentile);
    }

    @Override
    CountAtBucket[] countsAtBuckets() {
        double cumulativeCount = 0.0;
        double lowerBoundValue = 0.0;
        CountAtBucket[] counts = new CountAtBucket[this.histogramBuckets.length];
        for (int i = 0; i < counts.length; ++i) {
            double higherBoundValue = this.histogramBuckets[i];
            double count = ((DoubleHistogram)this.accumulatedHistogram()).getCountBetweenValues(lowerBoundValue, higherBoundValue);
            lowerBoundValue = ((DoubleHistogram)this.accumulatedHistogram()).nextNonEquivalentValue(higherBoundValue);
            counts[i] = new CountAtBucket(higherBoundValue, this.isCumulativeBucketCounts ? cumulativeCount + count : count);
        }
        return counts;
    }

    private int percentilePrecision(DistributionStatisticConfig config) {
        return config.getPercentilePrecision() == null ? 1 : config.getPercentilePrecision();
    }

    @Override
    void outputSummary(PrintStream out, double bucketScaling) {
        ((DoubleHistogram)this.accumulatedHistogram()).outputPercentileDistribution(out, bucketScaling);
    }
}

