/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.guava.graph;

import io.opentelemetry.testing.internal.guava.collect.BiMap;
import io.opentelemetry.testing.internal.guava.collect.HashBiMap;
import io.opentelemetry.testing.internal.guava.collect.ImmutableBiMap;
import io.opentelemetry.testing.internal.guava.graph.AbstractUndirectedNetworkConnections;
import io.opentelemetry.testing.internal.guava.graph.EdgesConnecting;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

final class UndirectedNetworkConnections<N, E>
extends AbstractUndirectedNetworkConnections<N, E> {
    UndirectedNetworkConnections(Map<E, N> incidentEdgeMap) {
        super(incidentEdgeMap);
    }

    static <N, E> UndirectedNetworkConnections<N, E> of() {
        return new UndirectedNetworkConnections(HashBiMap.create(2));
    }

    static <N, E> UndirectedNetworkConnections<N, E> ofImmutable(Map<E, N> incidentEdges) {
        return new UndirectedNetworkConnections<N, E>(ImmutableBiMap.copyOf(incidentEdges));
    }

    @Override
    public Set<N> adjacentNodes() {
        return Collections.unmodifiableSet(((BiMap)this.incidentEdgeMap).values());
    }

    @Override
    public Set<E> edgesConnecting(N node) {
        return new EdgesConnecting(((BiMap)this.incidentEdgeMap).inverse(), node);
    }
}

