/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.guava.collect;

import io.opentelemetry.testing.internal.guava.annotations.GwtCompatible;
import io.opentelemetry.testing.internal.guava.annotations.GwtIncompatible;
import io.opentelemetry.testing.internal.guava.annotations.J2ktIncompatible;
import io.opentelemetry.testing.internal.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.guava.collect.IndexedImmutableSet;
import java.util.Set;
import org.jspecify.annotations.Nullable;

@GwtCompatible(serializable=true)
final class JdkBackedImmutableSet<E>
extends IndexedImmutableSet<E> {
    private final Set<?> delegate;
    private final ImmutableList<E> delegateList;

    JdkBackedImmutableSet(Set<?> delegate, ImmutableList<E> delegateList) {
        this.delegate = delegate;
        this.delegateList = delegateList;
    }

    @Override
    E get(int index) {
        return this.delegateList.get(index);
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.delegate.contains(object);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int size() {
        return this.delegateList.size();
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

