/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.guava.collect;

import io.opentelemetry.testing.internal.guava.annotations.GwtCompatible;
import io.opentelemetry.testing.internal.guava.annotations.GwtIncompatible;
import io.opentelemetry.testing.internal.guava.annotations.J2ktIncompatible;
import io.opentelemetry.testing.internal.guava.base.Function;
import io.opentelemetry.testing.internal.guava.base.Objects;
import io.opentelemetry.testing.internal.guava.base.Preconditions;
import io.opentelemetry.testing.internal.guava.collect.Ordering;
import io.opentelemetry.testing.internal.guava.collect.ParametricNullness;
import java.io.Serializable;
import org.jspecify.annotations.Nullable;

@GwtCompatible(serializable=true)
final class ByFunctionOrdering<F, T>
extends Ordering<F>
implements Serializable {
    final Function<F, ? extends T> function;
    final Ordering<T> ordering;
    @GwtIncompatible
    @J2ktIncompatible
    private static final long serialVersionUID = 0L;

    ByFunctionOrdering(Function<F, ? extends T> function, Ordering<T> ordering) {
        this.function = Preconditions.checkNotNull(function);
        this.ordering = Preconditions.checkNotNull(ordering);
    }

    @Override
    public int compare(@ParametricNullness F left, @ParametricNullness F right) {
        return this.ordering.compare(this.function.apply(left), this.function.apply(right));
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ByFunctionOrdering) {
            ByFunctionOrdering that = (ByFunctionOrdering)object;
            return this.function.equals(that.function) && this.ordering.equals(that.ordering);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.function, this.ordering);
    }

    public String toString() {
        return this.ordering + ".onResultOf(" + this.function + ")";
    }
}

