/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.brotli4j.decoder;

import java.io.IOException;
import java.nio.ByteBuffer;

public class DecoderJNI {
    private static native ByteBuffer nativeCreate(long[] var0);

    private static native void nativePush(long[] var0, int var1);

    private static native ByteBuffer nativePull(long[] var0);

    private static native void nativeDestroy(long[] var0);

    private static native boolean nativeAttachDictionary(long[] var0, ByteBuffer var1);

    public static class Wrapper {
        private final long[] context = new long[3];
        private final ByteBuffer inputBuffer;
        private Status lastStatus = Status.NEEDS_MORE_INPUT;
        private boolean fresh = true;

        public Wrapper(int inputBufferSize) throws IOException {
            this.context[1] = inputBufferSize;
            this.inputBuffer = DecoderJNI.nativeCreate(this.context);
            if (this.context[0] == 0L) {
                throw new IOException("failed to initialize native brotli decoder");
            }
        }

        public boolean attachDictionary(ByteBuffer dictionary) {
            if (!dictionary.isDirect()) {
                throw new IllegalArgumentException("only direct buffers allowed");
            }
            if (this.context[0] == 0L) {
                throw new IllegalStateException("brotli decoder is already destroyed");
            }
            if (!this.fresh) {
                throw new IllegalStateException("decoding is already started");
            }
            return DecoderJNI.nativeAttachDictionary(this.context, dictionary);
        }

        public void push(int length) {
            if (length < 0) {
                throw new IllegalArgumentException("negative block length");
            }
            if (this.context[0] == 0L) {
                throw new IllegalStateException("brotli decoder is already destroyed");
            }
            if (this.lastStatus != Status.NEEDS_MORE_INPUT && this.lastStatus != Status.OK) {
                throw new IllegalStateException("pushing input to decoder in " + (Object)((Object)this.lastStatus) + " state");
            }
            if (this.lastStatus == Status.OK && length != 0) {
                throw new IllegalStateException("pushing input to decoder in OK state");
            }
            this.fresh = false;
            DecoderJNI.nativePush(this.context, length);
            this.parseStatus();
        }

        private void parseStatus() {
            long status = this.context[1];
            this.lastStatus = status == 1L ? Status.DONE : (status == 2L ? Status.NEEDS_MORE_INPUT : (status == 3L ? Status.NEEDS_MORE_OUTPUT : (status == 4L ? Status.OK : Status.ERROR)));
        }

        public Status getStatus() {
            return this.lastStatus;
        }

        public ByteBuffer getInputBuffer() {
            return this.inputBuffer;
        }

        public boolean hasOutput() {
            return this.context[2] != 0L;
        }

        public ByteBuffer pull() {
            if (this.context[0] == 0L) {
                throw new IllegalStateException("brotli decoder is already destroyed");
            }
            if (this.lastStatus != Status.NEEDS_MORE_OUTPUT && !this.hasOutput()) {
                throw new IllegalStateException("pulling output from decoder in " + (Object)((Object)this.lastStatus) + " state");
            }
            this.fresh = false;
            ByteBuffer result = DecoderJNI.nativePull(this.context);
            this.parseStatus();
            return result;
        }

        public void destroy() {
            if (this.context[0] == 0L) {
                throw new IllegalStateException("brotli decoder is already destroyed");
            }
            DecoderJNI.nativeDestroy(this.context);
            this.context[0] = 0L;
        }

        protected void finalize() throws Throwable {
            if (this.context[0] != 0L) {
                this.destroy();
            }
            super.finalize();
        }
    }

    public static enum Status {
        ERROR,
        DONE,
        NEEDS_MORE_INPUT,
        NEEDS_MORE_OUTPUT,
        OK;

    }
}

