/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.throttling;

import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.throttling.AbstractThrottlingServiceBuilder;
import io.opentelemetry.testing.internal.armeria.server.throttling.ThrottlingAcceptHandler;
import io.opentelemetry.testing.internal.armeria.server.throttling.ThrottlingRejectHandler;
import io.opentelemetry.testing.internal.armeria.server.throttling.ThrottlingService;
import io.opentelemetry.testing.internal.armeria.server.throttling.ThrottlingStrategy;
import java.util.Objects;
import java.util.function.Function;

public final class ThrottlingServiceBuilder
extends AbstractThrottlingServiceBuilder<HttpRequest, HttpResponse> {
    private static final ThrottlingRejectHandler<HttpRequest, HttpResponse> DEFAULT_REJECT_HANDLER = (delegate, ctx, req, cause) -> HttpResponse.of(HttpStatus.TOO_MANY_REQUESTS);

    ThrottlingServiceBuilder(ThrottlingStrategy<HttpRequest> strategy) {
        super(strategy, DEFAULT_REJECT_HANDLER);
    }

    public ThrottlingServiceBuilder onAcceptedRequest(ThrottlingAcceptHandler<HttpRequest, HttpResponse> acceptHandler) {
        this.setAcceptHandler(acceptHandler);
        return this;
    }

    public ThrottlingServiceBuilder onRejectedRequest(ThrottlingRejectHandler<HttpRequest, HttpResponse> rejectHandler) {
        this.setRejectHandler(rejectHandler);
        return this;
    }

    public ThrottlingService build(HttpService delegate) {
        return new ThrottlingService(Objects.requireNonNull(delegate, "delegate"), this.getStrategy(), this.getAcceptHandler(), this.getRejectHandler());
    }

    public Function<? super HttpService, ThrottlingService> newDecorator() {
        ThrottlingStrategy strategy = this.getStrategy();
        ThrottlingAcceptHandler acceptHandler = this.getAcceptHandler();
        ThrottlingRejectHandler rejectHandler = this.getRejectHandler();
        return service -> new ThrottlingService((HttpService)service, strategy, acceptHandler, rejectHandler);
    }
}

