/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.throttling;

import io.opentelemetry.testing.internal.armeria.common.Request;
import io.opentelemetry.testing.internal.armeria.common.Response;
import io.opentelemetry.testing.internal.armeria.server.Service;
import io.opentelemetry.testing.internal.armeria.server.throttling.ThrottlingAcceptHandler;
import io.opentelemetry.testing.internal.armeria.server.throttling.ThrottlingRejectHandler;
import io.opentelemetry.testing.internal.armeria.server.throttling.ThrottlingStrategy;
import java.util.Objects;

abstract class AbstractThrottlingServiceBuilder<I extends Request, O extends Response> {
    private final ThrottlingStrategy<I> strategy;
    private ThrottlingAcceptHandler<I, O> acceptHandler;
    private ThrottlingRejectHandler<I, O> rejectHandler;

    AbstractThrottlingServiceBuilder(ThrottlingStrategy<I> strategy, ThrottlingRejectHandler<I, O> defaultRejectHandler) {
        this.strategy = Objects.requireNonNull(strategy, "strategy");
        this.acceptHandler = Service::serve;
        this.rejectHandler = Objects.requireNonNull(defaultRejectHandler, "defaultRejectHandler");
    }

    final ThrottlingStrategy<I> getStrategy() {
        return this.strategy;
    }

    final void setAcceptHandler(ThrottlingAcceptHandler<I, O> acceptHandler) {
        this.acceptHandler = Objects.requireNonNull(acceptHandler, "acceptHandler");
    }

    final ThrottlingAcceptHandler<I, O> getAcceptHandler() {
        return this.acceptHandler;
    }

    final void setRejectHandler(ThrottlingRejectHandler<I, O> rejectHandler) {
        this.rejectHandler = Objects.requireNonNull(rejectHandler, "rejectHandler");
    }

    final ThrottlingRejectHandler<I, O> getRejectHandler() {
        return this.rejectHandler;
    }
}

