/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.throttling;

import io.opentelemetry.testing.internal.armeria.common.Request;
import io.opentelemetry.testing.internal.armeria.common.Response;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.server.Service;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.SimpleDecoratingService;
import io.opentelemetry.testing.internal.armeria.server.throttling.ThrottlingAcceptHandler;
import io.opentelemetry.testing.internal.armeria.server.throttling.ThrottlingRejectHandler;
import io.opentelemetry.testing.internal.armeria.server.throttling.ThrottlingStrategy;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public abstract class AbstractThrottlingService<I extends Request, O extends Response>
extends SimpleDecoratingService<I, O> {
    private final ThrottlingStrategy<I> strategy;
    private final Function<CompletionStage<? extends O>, O> responseConverter;
    private final ThrottlingAcceptHandler<I, O> acceptHandler;
    private final ThrottlingRejectHandler<I, O> rejectHandler;

    protected AbstractThrottlingService(Service<I, O> delegate, ThrottlingStrategy<I> strategy, Function<CompletionStage<? extends O>, O> responseConverter, ThrottlingAcceptHandler<I, O> acceptHandler, ThrottlingRejectHandler<I, O> rejectHandler) {
        super(delegate);
        this.strategy = Objects.requireNonNull(strategy, "strategy");
        this.responseConverter = Objects.requireNonNull(responseConverter, "responseConverter");
        this.acceptHandler = Objects.requireNonNull(acceptHandler, "acceptHandler");
        this.rejectHandler = Objects.requireNonNull(rejectHandler, "rejectHandler");
    }

    @Override
    public final O serve(ServiceRequestContext ctx, I req) throws Exception {
        return (O)((Response)this.responseConverter.apply(this.strategy.accept(ctx, req).handleAsync((accept, cause) -> {
            try {
                if (cause != null || !accept.booleanValue()) {
                    return this.rejectHandler.handleRejected((Service)this.unwrap(), ctx, (Request)req, (Throwable)cause);
                }
                return this.acceptHandler.handleAccepted((Service)this.unwrap(), ctx, (Request)req);
            }
            catch (Exception e) {
                return (Response)Exceptions.throwUnsafely(e);
            }
        }, ctx.eventLoop())));
    }
}

