/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.management;

import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.server.AbstractHttpService;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.management.HeapDumpService;
import io.opentelemetry.testing.internal.armeria.server.management.ThreadDumpService;

@UnstableApi
public final class ManagementService
extends AbstractHttpService {
    private static final ManagementService INSTANCE = new ManagementService();

    public static ManagementService of() {
        return INSTANCE;
    }

    ManagementService() {
    }

    @Override
    public HttpResponse doGet(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        String path;
        switch (path = ctx.mappedPath()) {
            case "/jvm/threaddump": {
                return ThreadDumpService.INSTANCE.serve(ctx, req);
            }
            case "/jvm/heapdump": {
                return HeapDumpService.INSTANCE.serve(ctx, req);
            }
        }
        return HttpResponse.of(HttpStatus.NOT_FOUND);
    }
}

