/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.logging;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.RequestId;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.RpcRequest;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLog;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestOnlyLog;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.internal.common.util.TemporaryThreadLocals;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.net.UrlEscapers;
import io.opentelemetry.testing.internal.armeria.internal.shaded.reflections.ReflectionUtils;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.logging.AccessLogType;
import io.opentelemetry.testing.internal.io.netty.util.AsciiString;
import io.opentelemetry.testing.internal.io.netty.util.AttributeKey;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

@FunctionalInterface
interface AccessLogComponent {
    @Nullable
    public Object getMessage(RequestLog var1);

    default public boolean addQuote() {
        return false;
    }

    public static AccessLogComponent ofText(String text) {
        return new TextComponent(text);
    }

    public static AccessLogComponent ofDefaultRequestTimestamp() {
        return new TimestampComponent(false, null);
    }

    public static AccessLogComponent ofPredefinedCommon(AccessLogType type) {
        return AccessLogComponent.ofPredefinedCommon(type, null);
    }

    public static AccessLogComponent ofPredefinedCommon(AccessLogType type, @Nullable String variable) {
        return new CommonComponent(type, type == AccessLogType.REQUEST_LINE, null, variable);
    }

    public static AccessLogComponent ofQuotedRequestHeader(CharSequence headerName) {
        return new HttpHeaderComponent(AccessLogType.REQUEST_HEADER, headerName, true, null);
    }

    public static class TextComponent
    implements AccessLogComponent {
        private final String text;

        static boolean isSupported(AccessLogType type) {
            return type == AccessLogType.TEXT;
        }

        TextComponent(String text) {
            this.text = Objects.requireNonNull(text, "text");
        }

        @Override
        public Object getMessage(RequestLog log) {
            return this.text;
        }
    }

    public static class TimestampComponent
    implements AccessLogComponent {
        static final DateTimeFormatter defaultDateTimeFormatter = DateTimeFormatter.ofPattern("dd/MMM/yyyy:HH:mm:ss Z", Locale.ENGLISH);
        static final ZoneId defaultZoneId = ZoneId.systemDefault();
        private static final Map<String, DateTimeFormatter> predefinedFormatters = ReflectionUtils.getFields(DateTimeFormatter.class, field -> {
            if (field == null) {
                return false;
            }
            int m = field.getModifiers();
            return Modifier.isPublic(m) && Modifier.isStatic(m) && Modifier.isFinal(m) && field.getType() == DateTimeFormatter.class;
        }).stream().collect(Collectors.toMap(Field::getName, f -> {
            try {
                return (DateTimeFormatter)f.get(null);
            }
            catch (Throwable cause) {
                throw new Error(cause);
            }
        }));
        private final boolean addQuote;
        private final DateTimeFormatter formatter;

        static boolean isSupported(AccessLogType type) {
            return type == AccessLogType.REQUEST_TIMESTAMP;
        }

        TimestampComponent(boolean addQuote, @Nullable String variable) {
            this.addQuote = addQuote;
            this.formatter = TimestampComponent.findFormatter(variable);
        }

        @Override
        @Nullable
        public Object getMessage(RequestLog log) {
            return this.formatter.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(log.requestStartTimeMillis()), defaultZoneId));
        }

        @Override
        public boolean addQuote() {
            return this.addQuote;
        }

        static DateTimeFormatter findFormatter(@Nullable String variable) {
            if (variable == null) {
                return defaultDateTimeFormatter;
            }
            DateTimeFormatter predefined = predefinedFormatters.get(variable);
            if (predefined != null) {
                return predefined;
            }
            try {
                return DateTimeFormatter.ofPattern(variable, Locale.ENGLISH);
            }
            catch (Throwable cause) {
                throw new IllegalArgumentException("unexpected date/time format variable: " + variable, cause);
            }
        }
    }

    public static class CommonComponent
    extends ResponseHeaderConditional {
        private final AccessLogType type;
        @Nullable
        private final String variable;

        static boolean isSupported(AccessLogType type) {
            switch (type) {
                case LOCAL_IP_ADDRESS: 
                case REMOTE_IP_ADDRESS: 
                case REMOTE_HOST: 
                case RFC931: 
                case AUTHENTICATED_USER: 
                case REQUEST_LINE: 
                case RESPONSE_STATUS_CODE: 
                case RESPONSE_LENGTH: 
                case REQUEST_ID: {
                    return true;
                }
            }
            return false;
        }

        CommonComponent(AccessLogType type, boolean addQuote, @Nullable Function<ResponseHeaders, Boolean> condition, @Nullable String variable) {
            super(condition, addQuote);
            Preconditions.checkArgument(CommonComponent.isSupported(Objects.requireNonNull(type, "type")), "Type '%s' is not acceptable by %s", (Object)type, (Object)CommonComponent.class.getName());
            this.type = type;
            this.variable = variable;
        }

        @Override
        @Nullable
        public Object getMessage0(RequestLog log) {
            switch (this.type) {
                case LOCAL_IP_ADDRESS: {
                    InetSocketAddress local = log.context().localAddress();
                    return local == null || local.isUnresolved() ? null : local.getAddress().getHostAddress();
                }
                case REMOTE_IP_ADDRESS: {
                    if ("c".equals(this.variable)) {
                        InetSocketAddress remote = log.context().remoteAddress();
                        return remote == null || remote.isUnresolved() ? null : remote.getAddress().getHostAddress();
                    }
                    ServiceRequestContext ctx = (ServiceRequestContext)log.context();
                    return ctx.clientAddress().getHostAddress();
                }
                case REMOTE_HOST: {
                    InetSocketAddress ra = log.context().remoteAddress();
                    return ra != null ? ra.getHostString() : null;
                }
                case RFC931: {
                    return null;
                }
                case AUTHENTICATED_USER: {
                    return log.authenticatedUser();
                }
                case REQUEST_LINE: {
                    String logName;
                    boolean isGrpc;
                    String httpMethodName = log.requestHeaders().method().name();
                    String path = log.requestHeaders().path();
                    String name = log.name();
                    RpcRequest rpcRequest = log.context().rpcRequest();
                    boolean bl = isGrpc = rpcRequest != null && "io.opentelemetry.testing.internal.armeria.internal.common.grpc.GrpcLogUtil".equals(rpcRequest.serviceType().getName());
                    if (!isGrpc) {
                        int idx;
                        String serviceName = log.serviceName();
                        if (serviceName != null && (idx = serviceName.lastIndexOf(46) + 1) > 0) {
                            serviceName = serviceName.substring(idx);
                        }
                        logName = rpcRequest == null && httpMethodName.equals(name) ? serviceName : serviceName + '/' + name;
                    } else {
                        logName = null;
                    }
                    String protocol = MoreObjects.firstNonNull(log.sessionProtocol(), log.context().sessionProtocol()).uriText();
                    try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
                        StringBuilder requestLine = tempThreadLocals.stringBuilder();
                        requestLine.append(httpMethodName).append(' ').append(path);
                        if (logName != null) {
                            requestLine.append('#').append(UrlEscapers.urlFragmentEscaper().escape(logName));
                        }
                        String string = requestLine.append(' ').append(protocol).toString();
                        return string;
                    }
                }
                case RESPONSE_STATUS_CODE: {
                    return log.responseHeaders().status().code();
                }
                case RESPONSE_LENGTH: {
                    return log.responseLength();
                }
                case REQUEST_ID: {
                    RequestId id = log.context().id();
                    if ("short".equals(this.variable)) {
                        return id.shortText();
                    }
                    return id.text();
                }
            }
            return null;
        }
    }

    public static class HttpHeaderComponent
    extends ResponseHeaderConditional {
        private final AsciiString headerName;
        private final Function<RequestLog, HttpHeaders> httpHeaders;

        static boolean isSupported(AccessLogType type) {
            return type == AccessLogType.REQUEST_HEADER || type == AccessLogType.RESPONSE_HEADER;
        }

        HttpHeaderComponent(AccessLogType logType, CharSequence headerName, boolean addQuote, @Nullable Function<ResponseHeaders, Boolean> condition) {
            super(condition, addQuote);
            this.headerName = HttpHeaderNames.of(Objects.requireNonNull(headerName, "headerName"));
            if (logType == AccessLogType.REQUEST_HEADER) {
                this.httpHeaders = RequestOnlyLog::requestHeaders;
            } else {
                assert (logType == AccessLogType.RESPONSE_HEADER) : logType.name();
                this.httpHeaders = RequestLog::responseHeaders;
            }
        }

        AsciiString headerName() {
            return this.headerName;
        }

        @Override
        @Nullable
        public Object getMessage0(RequestLog log) {
            return this.httpHeaders.apply(log).get(this.headerName);
        }
    }

    public static class RequestLogComponent
    extends ResponseHeaderConditional {
        private final Function<RequestLog, Object> resolver;

        static boolean isSupported(AccessLogType type) {
            return type == AccessLogType.REQUEST_LOG;
        }

        RequestLogComponent(String variable, boolean addQuote, @Nullable Function<ResponseHeaders, Boolean> condition) {
            super(condition, addQuote);
            this.resolver = RequestLogComponent.findResolver(Objects.requireNonNull(variable, "variable"));
        }

        @Override
        @Nullable
        Object getMessage0(RequestLog log) {
            return this.resolver.apply(log);
        }

        @Nullable
        private static String handleThrowable(@Nullable Throwable cause) {
            if (cause == null) {
                return null;
            }
            String message = (cause = Exceptions.peel(cause)).getMessage();
            return message != null ? cause.getClass().getSimpleName() + ": " + message : cause.getClass().getSimpleName();
        }

        private static Function<RequestLog, Object> findResolver(String variable) {
            switch (variable) {
                case "method": {
                    return log -> log.requestHeaders().method();
                }
                case "path": {
                    return log -> log.context().path();
                }
                case "query": {
                    return log -> log.context().query();
                }
                case "requestStartTimeMillis": {
                    return RequestOnlyLog::requestStartTimeMillis;
                }
                case "requestEndTimeMillis": {
                    return log -> Instant.ofEpochMilli(log.requestStartTimeMillis()).plusNanos(log.requestDurationNanos()).toEpochMilli();
                }
                case "requestDurationMillis": {
                    return log -> Duration.ofNanos(log.requestDurationNanos()).toMillis();
                }
                case "requestDurationNanos": {
                    return RequestOnlyLog::requestDurationNanos;
                }
                case "requestLength": {
                    return RequestOnlyLog::requestLength;
                }
                case "requestCause": {
                    return log -> RequestLogComponent.handleThrowable(log.requestCause());
                }
                case "requestContentPreview": {
                    return RequestOnlyLog::requestContentPreview;
                }
                case "responseStartTimeMillis": {
                    return RequestLog::responseStartTimeMillis;
                }
                case "responseEndTimeMillis": {
                    return log -> Instant.ofEpochMilli(log.responseStartTimeMillis()).plusNanos(log.responseDurationNanos()).toEpochMilli();
                }
                case "responseDurationMillis": {
                    return log -> Duration.ofNanos(log.responseDurationNanos()).toMillis();
                }
                case "responseDurationNanos": {
                    return RequestLog::responseDurationNanos;
                }
                case "responseLength": {
                    return RequestLog::responseLength;
                }
                case "responseCause": {
                    return log -> RequestLogComponent.handleThrowable(log.responseCause());
                }
                case "responseContentPreview": {
                    return RequestLog::responseContentPreview;
                }
                case "totalDurationMillis": {
                    return log -> Duration.ofNanos(log.totalDurationNanos()).toMillis();
                }
                case "totalDurationNanos": {
                    return RequestLog::totalDurationNanos;
                }
                case "sessionProtocol": {
                    return RequestOnlyLog::sessionProtocol;
                }
                case "serializationFormat": {
                    return log -> log.scheme().serializationFormat();
                }
                case "scheme": {
                    return RequestOnlyLog::scheme;
                }
                case "host": {
                    return log -> {
                        String authority = log.requestHeaders().authority();
                        if ("?".equals(authority)) {
                            InetSocketAddress remoteAddr = log.context().remoteAddress();
                            assert (remoteAddr != null);
                            return remoteAddr.getHostString();
                        }
                        return authority;
                    };
                }
                case "status": {
                    return log -> log.responseHeaders().status();
                }
                case "statusCode": {
                    return log -> log.responseHeaders().status().code();
                }
            }
            throw new IllegalArgumentException("unexpected request log variable: " + variable);
        }
    }

    public static class AttributeComponent
    extends ResponseHeaderConditional {
        private final AttributeKey<?> key;
        private final Function<Object, String> stringifer;

        static boolean isSupported(AccessLogType type) {
            return type == AccessLogType.ATTRIBUTE;
        }

        AttributeComponent(String attributeName, Function<Object, String> stringifer, boolean addQuote, @Nullable Function<ResponseHeaders, Boolean> condition) {
            super(condition, addQuote);
            this.key = AttributeKey.valueOf(Objects.requireNonNull(attributeName, "attributeName"));
            this.stringifer = Objects.requireNonNull(stringifer, "stringifer");
        }

        AttributeKey<?> key() {
            return this.key;
        }

        @Override
        @Nullable
        Object getMessage0(RequestLog log) {
            Object value = log.context().attr(this.key);
            return value != null ? this.stringifer.apply(value) : null;
        }
    }

    public static abstract class ResponseHeaderConditional
    implements AccessLogComponent {
        @Nullable
        private final Function<ResponseHeaders, Boolean> condition;
        private final boolean addQuote;

        protected ResponseHeaderConditional(@Nullable Function<ResponseHeaders, Boolean> condition, boolean addQuote) {
            this.condition = condition;
            this.addQuote = addQuote;
        }

        @Nullable
        Function<ResponseHeaders, Boolean> condition() {
            return this.condition;
        }

        @Override
        @Nullable
        public final Object getMessage(RequestLog log) {
            if (this.condition != null && !this.condition.apply(log.responseHeaders()).booleanValue()) {
                return null;
            }
            return this.getMessage0(log);
        }

        @Nullable
        abstract Object getMessage0(RequestLog var1);

        @Override
        public boolean addQuote() {
            return this.addQuote;
        }
    }
}

