/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.file;

import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.server.file.DefaultMediaTypeResolver;
import java.util.Objects;

@FunctionalInterface
@UnstableApi
public interface MediaTypeResolver {
    public static MediaTypeResolver ofDefault() {
        return DefaultMediaTypeResolver.INSTANCE;
    }

    @Nullable
    public MediaType guessFromPath(String var1, @Nullable String var2);

    default public MediaTypeResolver orElse(MediaTypeResolver other) {
        Objects.requireNonNull(other, "other");
        if (this == other) {
            return this;
        }
        return (path, contentEncoding) -> {
            MediaType mediaType = this.guessFromPath(path, contentEncoding);
            if (mediaType != null) {
                return mediaType;
            }
            return other.guessFromPath(path, contentEncoding);
        };
    }
}

