/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.docs;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableListMultimap;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Iterables;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ListMultimap;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Streams;
import io.opentelemetry.testing.internal.armeria.server.docs.MethodInfo;
import io.opentelemetry.testing.internal.armeria.server.docs.ServiceInfo;
import io.opentelemetry.testing.internal.armeria.server.docs.ServiceSpecification;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

final class ExampleSupport {
    private final Map<String, ListMultimap<String, HttpHeaders>> exampleHeaders;
    private final Map<String, ListMultimap<String, String>> exampleRequests;
    private final Map<String, ListMultimap<String, String>> examplePaths;
    private final Map<String, ListMultimap<String, String>> exampleQueries;

    ExampleSupport(Map<String, ListMultimap<String, HttpHeaders>> exampleHeaders, Map<String, ListMultimap<String, String>> exampleRequests, Map<String, ListMultimap<String, String>> examplePaths, Map<String, ListMultimap<String, String>> exampleQueries) {
        this.exampleHeaders = exampleHeaders;
        this.exampleRequests = exampleRequests;
        this.examplePaths = examplePaths;
        this.exampleQueries = exampleQueries;
    }

    ServiceSpecification addExamples(ServiceSpecification spec) {
        List serviceWithExample = spec.services().stream().map(this::addServiceExamples).collect(ImmutableList.toImmutableList());
        Iterable<HttpHeaders> exampleHeaders = Iterables.concat(spec.exampleHeaders(), ((ListMultimap)this.exampleHeaders.getOrDefault("", ImmutableListMultimap.of())).get(""));
        return new ServiceSpecification(serviceWithExample, spec.enums(), spec.structs(), spec.exceptions(), exampleHeaders, spec.docServiceRoute());
    }

    private ServiceInfo addServiceExamples(ServiceInfo service) {
        ListMultimap exampleHeaders = this.exampleHeaders.getOrDefault(service.name(), ImmutableListMultimap.of());
        ListMultimap exampleRequests = this.exampleRequests.getOrDefault(service.name(), ImmutableListMultimap.of());
        ListMultimap examplePaths = this.examplePaths.getOrDefault(service.name(), ImmutableListMultimap.of());
        ListMultimap exampleQueries = this.exampleQueries.getOrDefault(service.name(), ImmutableListMultimap.of());
        List methodsWithExamples = service.methods().stream().map(m -> new MethodInfo(m.name(), m.returnTypeSignature(), m.parameters(), m.useParameterAsRoot(), m.exceptionTypeSignatures(), m.endpoints(), ExampleSupport.concatAndDedup(exampleHeaders.get(m.name()), m.exampleHeaders()), ExampleSupport.concatAndDedup(exampleRequests.get(m.name()), m.exampleRequests()), ExampleSupport.concatAndDedup(examplePaths.get(m.name()), m.examplePaths()), ExampleSupport.concatAndDedup(exampleQueries.get(m.name()), m.exampleQueries()), m.httpMethod(), m.descriptionInfo(), m.id())).collect(ImmutableList.toImmutableList());
        Iterable<HttpHeaders> serviceExampleHeaders = Iterables.concat(service.exampleHeaders(), exampleHeaders.get(""));
        return service.withMethods(methodsWithExamples).withExampleHeaders(serviceExampleHeaders);
    }

    private static <T> Iterable<T> concatAndDedup(Iterable<T> first, Iterable<T> second) {
        return Stream.concat(Streams.stream(first), Streams.stream(second)).distinct().collect(ImmutableList.toImmutableList());
    }
}

