/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.auth;

import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.auth.BasicToken;
import io.opentelemetry.testing.internal.armeria.common.auth.OAuth1aToken;
import io.opentelemetry.testing.internal.armeria.common.auth.OAuth2Token;
import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefix;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.Service;
import io.opentelemetry.testing.internal.armeria.server.auth.AuthFailureHandler;
import io.opentelemetry.testing.internal.armeria.server.auth.AuthService;
import io.opentelemetry.testing.internal.armeria.server.auth.AuthSuccessHandler;
import io.opentelemetry.testing.internal.armeria.server.auth.AuthTokenExtractors;
import io.opentelemetry.testing.internal.armeria.server.auth.Authorizer;
import io.opentelemetry.testing.internal.armeria.server.auth.BasicTokenExtractor;
import io.opentelemetry.testing.internal.armeria.server.auth.DelegatingHttpRequestAuthorizer;
import io.opentelemetry.testing.internal.armeria.server.auth.OAuth1aTokenExtractor;
import io.opentelemetry.testing.internal.armeria.server.auth.OAuth2TokenExtractor;
import java.util.Objects;
import java.util.function.Function;

public final class AuthServiceBuilder {
    @Nullable
    private Authorizer<HttpRequest> authorizer;
    private AuthSuccessHandler successHandler = Service::serve;
    private AuthFailureHandler failureHandler = (delegate, ctx, req, cause) -> {
        if (cause != null) {
            AuthService.logger.warn("Unexpected exception during authorization.", cause);
        }
        return HttpResponse.of(HttpStatus.UNAUTHORIZED);
    };
    private MeterIdPrefix meterIdPrefix = new MeterIdPrefix("armeria.server.auth");

    AuthServiceBuilder() {
    }

    public AuthServiceBuilder add(Authorizer<HttpRequest> authorizer) {
        Objects.requireNonNull(authorizer, "authorizer");
        this.authorizer = this.authorizer == null ? authorizer : this.authorizer.orElse(authorizer);
        return this;
    }

    public AuthServiceBuilder add(Iterable<? extends Authorizer<HttpRequest>> authorizers) {
        Objects.requireNonNull(authorizers, "authorizers");
        authorizers.forEach(a -> {
            Objects.requireNonNull(a, "authorizers contains null.");
            this.add((Authorizer<HttpRequest>)a);
        });
        return this;
    }

    public AuthServiceBuilder addBasicAuth(Authorizer<? super BasicToken> authorizer) {
        return this.addTokenAuthorizer(AuthTokenExtractors.basic(), Objects.requireNonNull(authorizer, "authorizer"));
    }

    public AuthServiceBuilder addBasicAuth(Authorizer<? super BasicToken> authorizer, CharSequence header) {
        return this.addTokenAuthorizer(new BasicTokenExtractor(Objects.requireNonNull(header, "header")), Objects.requireNonNull(authorizer, "authorizer"));
    }

    public AuthServiceBuilder addOAuth1a(Authorizer<? super OAuth1aToken> authorizer) {
        return this.addTokenAuthorizer(AuthTokenExtractors.oAuth1a(), Objects.requireNonNull(authorizer, "authorizer"));
    }

    public AuthServiceBuilder addOAuth1a(Authorizer<? super OAuth1aToken> authorizer, CharSequence header) {
        return this.addTokenAuthorizer(new OAuth1aTokenExtractor(Objects.requireNonNull(header, "header")), Objects.requireNonNull(authorizer, "authorizer"));
    }

    public AuthServiceBuilder addOAuth2(Authorizer<? super OAuth2Token> authorizer) {
        return this.addTokenAuthorizer(AuthTokenExtractors.oAuth2(), Objects.requireNonNull(authorizer, "authorizer"));
    }

    public AuthServiceBuilder addOAuth2(Authorizer<? super OAuth2Token> authorizer, CharSequence header) {
        return this.addTokenAuthorizer(new OAuth2TokenExtractor(Objects.requireNonNull(header, "header")), Objects.requireNonNull(authorizer, "authorizer"));
    }

    public <T> AuthServiceBuilder addTokenAuthorizer(Function<? super RequestHeaders, @Nullable T> tokenExtractor, Authorizer<? super T> authorizer) {
        DelegatingHttpRequestAuthorizer<? super T> requestAuthorizer = new DelegatingHttpRequestAuthorizer<T>(tokenExtractor, authorizer);
        this.add(requestAuthorizer);
        return this;
    }

    public AuthServiceBuilder onSuccess(AuthSuccessHandler successHandler) {
        this.successHandler = Objects.requireNonNull(successHandler, "successHandler");
        return this;
    }

    public AuthServiceBuilder onFailure(AuthFailureHandler failureHandler) {
        this.failureHandler = Objects.requireNonNull(failureHandler, "failureHandler");
        return this;
    }

    public AuthServiceBuilder meterIdPrefix(MeterIdPrefix meterIdPrefix) {
        this.meterIdPrefix = Objects.requireNonNull(meterIdPrefix, "meterIdPrefix");
        return this;
    }

    public AuthService build(HttpService delegate) {
        return new AuthService(Objects.requireNonNull(delegate, "delegate"), this.authorizer(), this.successHandler, this.failureHandler, this.meterIdPrefix);
    }

    private AuthService build(HttpService delegate, Authorizer<HttpRequest> authorizer) {
        return new AuthService(Objects.requireNonNull(delegate, "delegate"), authorizer, this.successHandler, this.failureHandler, this.meterIdPrefix);
    }

    public Function<? super HttpService, AuthService> newDecorator() {
        Authorizer<HttpRequest> authorizer = this.authorizer();
        return delegate -> this.build((HttpService)delegate, authorizer);
    }

    private Authorizer<HttpRequest> authorizer() {
        if (this.authorizer == null) {
            throw new IllegalStateException("no " + Authorizer.class.getSimpleName() + " was added.");
        }
        return this.authorizer;
    }
}

