/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.annotation;

import io.opentelemetry.testing.internal.armeria.common.FilteredHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpObject;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.ClassUtil;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.annotation.ResponseConverterFunction;
import io.opentelemetry.testing.internal.armeria.server.file.HttpFile;
import java.lang.reflect.Type;
import org.reactivestreams.Subscriber;

public final class HttpFileResponseConverterFunction
implements ResponseConverterFunction {
    @Override
    @Nullable
    public Boolean isResponseStreaming(Type returnType, @Nullable MediaType produceType) {
        Class<?> clazz = ClassUtil.typeToClass(ClassUtil.unwrapUnaryAsyncType(returnType));
        if (clazz == null) {
            return null;
        }
        if (HttpFile.class.isAssignableFrom(clazz)) {
            return true;
        }
        return null;
    }

    @Override
    public HttpResponse convertResponse(ServiceRequestContext ctx, final ResponseHeaders headers, @Nullable Object result, final HttpHeaders trailers) throws Exception {
        if (result instanceof HttpFile) {
            HttpResponse originalRes = ((HttpFile)result).asService().serve(ctx, ctx.request());
            if (!HttpFileResponseConverterFunction.shouldOverride(headers, trailers)) {
                return originalRes;
            }
            return new FilteredHttpResponse(originalRes){
                private boolean trailerSent;

                @Override
                protected HttpObject filter(HttpObject obj) {
                    if (obj instanceof ResponseHeaders) {
                        ResponseHeaders originalHeaders = (ResponseHeaders)obj;
                        if (!originalHeaders.status().isInformational()) {
                            return headers.toBuilder().set((Iterable)originalHeaders).build();
                        }
                    } else if (obj instanceof HttpHeaders) {
                        this.trailerSent = true;
                        if (!trailers.isEmpty()) {
                            return trailers.toBuilder().set((HttpHeaders)obj).build();
                        }
                    }
                    return obj;
                }

                @Override
                protected void beforeComplete(Subscriber<? super HttpObject> subscriber) {
                    if (!trailers.isEmpty() && !this.trailerSent) {
                        subscriber.onNext(trailers);
                    }
                }
            };
        }
        return (HttpResponse)ResponseConverterFunction.fallthrough();
    }

    private static boolean shouldOverride(ResponseHeaders headers, HttpHeaders trailers) {
        if (!trailers.isEmpty()) {
            return true;
        }
        if (headers.isEmpty()) {
            return false;
        }
        return headers.size() != 1 || !headers.contains(HttpHeaderNames.STATUS);
    }
}

