/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.RequestId;
import io.opentelemetry.testing.internal.armeria.common.SuccessFunction;
import io.opentelemetry.testing.internal.armeria.common.TlsProvider;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefix;
import io.opentelemetry.testing.internal.armeria.common.util.BlockingTaskExecutor;
import io.opentelemetry.testing.internal.armeria.common.util.TlsEngineType;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Ascii;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Streams;
import io.opentelemetry.testing.internal.armeria.server.DomainMappingBuilder;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.MultipartRemovalStrategy;
import io.opentelemetry.testing.internal.armeria.server.RejectedRouteHandler;
import io.opentelemetry.testing.internal.armeria.server.Routed;
import io.opentelemetry.testing.internal.armeria.server.Router;
import io.opentelemetry.testing.internal.armeria.server.Routers;
import io.opentelemetry.testing.internal.armeria.server.RoutingContext;
import io.opentelemetry.testing.internal.armeria.server.RoutingResult;
import io.opentelemetry.testing.internal.armeria.server.RoutingStatus;
import io.opentelemetry.testing.internal.armeria.server.Server;
import io.opentelemetry.testing.internal.armeria.server.ServerConfig;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.ServiceNaming;
import io.opentelemetry.testing.internal.armeria.server.ShutdownSupport;
import io.opentelemetry.testing.internal.armeria.server.logging.AccessLogWriter;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoopGroup;
import io.opentelemetry.testing.internal.io.netty.handler.ssl.SslContext;
import io.opentelemetry.testing.internal.io.netty.util.Mapping;
import io.opentelemetry.testing.internal.io.netty.util.ReferenceCountUtil;
import java.net.IDN;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public final class VirtualHost {
    static final Pattern HOSTNAME_WITH_NO_PORT_PATTERN = Pattern.compile("^(?:[-_a-zA-Z0-9]|[-_a-zA-Z0-9][-_.a-zA-Z0-9]*[-_a-zA-Z0-9])$");
    @Nullable
    private ServerConfig serverConfig;
    private final String originalDefaultHostname;
    private final String originalHostnamePattern;
    private final String defaultHostname;
    private final String hostnamePattern;
    private final int port;
    @Nullable
    private final SslContext sslContext;
    @Nullable
    private final TlsProvider tlsProvider;
    @Nullable
    private final TlsEngineType tlsEngineType;
    private final Router<ServiceConfig> router;
    private final List<ServiceConfig> serviceConfigs;
    private final ServiceConfig fallbackServiceConfig;
    private final Logger accessLogger;
    private final ServiceNaming defaultServiceNaming;
    @Nullable
    private final String defaultLogName;
    private final long requestTimeoutMillis;
    private final long maxRequestLength;
    private final boolean verboseResponses;
    private final AccessLogWriter accessLogWriter;
    private final BlockingTaskExecutor blockingTaskExecutor;
    private final long requestAutoAbortDelayMillis;
    private final SuccessFunction successFunction;
    private final Path multipartUploadsLocation;
    private final MultipartRemovalStrategy multipartRemovalStrategy;
    private final EventLoopGroup serviceWorkerGroup;
    private final List<ShutdownSupport> shutdownSupports;
    private final Function<RoutingContext, RequestId> requestIdGenerator;

    VirtualHost(String defaultHostname, String hostnamePattern, int port, @Nullable SslContext sslContext, @Nullable TlsProvider tlsProvider, @Nullable TlsEngineType tlsEngineType, Iterable<ServiceConfig> serviceConfigs, ServiceConfig fallbackServiceConfig, RejectedRouteHandler rejectionHandler, Function<? super VirtualHost, ? extends Logger> accessLoggerMapper, ServiceNaming defaultServiceNaming, @Nullable String defaultLogName, long requestTimeoutMillis, long maxRequestLength, boolean verboseResponses, AccessLogWriter accessLogWriter, BlockingTaskExecutor blockingTaskExecutor, long requestAutoAbortDelayMillis, SuccessFunction successFunction, Path multipartUploadsLocation, MultipartRemovalStrategy multipartRemovalStrategy, EventLoopGroup serviceWorkerGroup, List<ShutdownSupport> shutdownSupports, Function<? super RoutingContext, ? extends RequestId> requestIdGenerator) {
        this.originalDefaultHostname = defaultHostname;
        this.originalHostnamePattern = hostnamePattern;
        if (port > 0) {
            this.defaultHostname = defaultHostname + ':' + port;
            this.hostnamePattern = hostnamePattern + ':' + port;
        } else {
            this.defaultHostname = defaultHostname;
            this.hostnamePattern = hostnamePattern;
        }
        this.port = port;
        this.sslContext = sslContext;
        this.tlsProvider = tlsProvider;
        this.tlsEngineType = tlsEngineType;
        this.defaultServiceNaming = defaultServiceNaming;
        this.defaultLogName = defaultLogName;
        this.requestTimeoutMillis = requestTimeoutMillis;
        this.maxRequestLength = maxRequestLength;
        this.verboseResponses = verboseResponses;
        this.accessLogWriter = accessLogWriter;
        this.blockingTaskExecutor = blockingTaskExecutor;
        this.requestAutoAbortDelayMillis = requestAutoAbortDelayMillis;
        this.successFunction = successFunction;
        this.multipartUploadsLocation = multipartUploadsLocation;
        this.multipartRemovalStrategy = multipartRemovalStrategy;
        this.serviceWorkerGroup = serviceWorkerGroup;
        this.shutdownSupports = shutdownSupports;
        Function<? super RoutingContext, ? extends RequestId> castRequestIdGenerator = Objects.requireNonNull(requestIdGenerator, "requestIdGenerator");
        this.requestIdGenerator = castRequestIdGenerator;
        Objects.requireNonNull(serviceConfigs, "serviceConfigs");
        Objects.requireNonNull(fallbackServiceConfig, "fallbackServiceConfig");
        this.serviceConfigs = Streams.stream(serviceConfigs).map(sc -> sc.withVirtualHost(this)).collect(ImmutableList.toImmutableList());
        this.fallbackServiceConfig = fallbackServiceConfig.withVirtualHost(this);
        this.router = Routers.ofVirtualHost(this, this.serviceConfigs, rejectionHandler);
        this.accessLogger = accessLoggerMapper.apply(this);
        Preconditions.checkState(this.accessLogger != null, "accessLoggerMapper.apply() has returned null for virtual host: %s.", hostnamePattern);
    }

    VirtualHost withNewSslContext(SslContext sslContext) {
        if (this.tlsProvider != null) {
            ReferenceCountUtil.release(sslContext);
            throw new IllegalStateException("Cannot set a new SslContext when TlsProvider is set.");
        }
        return new VirtualHost(this.originalDefaultHostname, this.originalHostnamePattern, this.port, sslContext, null, this.tlsEngineType, this.serviceConfigs, this.fallbackServiceConfig, RejectedRouteHandler.DISABLED, host -> this.accessLogger, this.defaultServiceNaming, this.defaultLogName, this.requestTimeoutMillis, this.maxRequestLength, this.verboseResponses, this.accessLogWriter, this.blockingTaskExecutor, this.requestAutoAbortDelayMillis, this.successFunction, this.multipartUploadsLocation, this.multipartRemovalStrategy, this.serviceWorkerGroup, this.shutdownSupports, this.requestIdGenerator);
    }

    static String normalizeDefaultHostname(String defaultHostname) {
        Objects.requireNonNull(defaultHostname, "defaultHostname");
        if (VirtualHost.needsNormalization(defaultHostname)) {
            defaultHostname = IDN.toASCII(defaultHostname, 1);
        }
        if (!HOSTNAME_WITH_NO_PORT_PATTERN.matcher(defaultHostname).matches()) {
            throw new IllegalArgumentException("defaultHostname: " + defaultHostname);
        }
        return Ascii.toLowerCase(defaultHostname);
    }

    static String normalizeHostnamePattern(String hostnamePattern) {
        Objects.requireNonNull(hostnamePattern, "hostnamePattern");
        if (VirtualHost.needsNormalization(hostnamePattern)) {
            hostnamePattern = IDN.toASCII(hostnamePattern, 1);
        }
        if (!"*".equals(hostnamePattern)) {
            String withoutWildCard;
            String string = withoutWildCard = hostnamePattern.startsWith("*.") ? hostnamePattern.substring(2) : hostnamePattern;
            if (!HOSTNAME_WITH_NO_PORT_PATTERN.matcher(withoutWildCard).matches()) {
                throw new IllegalArgumentException("hostnamePattern: " + hostnamePattern);
            }
        }
        return Ascii.toLowerCase(hostnamePattern);
    }

    static void validateHostnamePattern(String hostnamePattern) {
        boolean validHostnamePattern = hostnamePattern.charAt(0) == '*' ? hostnamePattern.length() >= 3 && hostnamePattern.charAt(1) == '.' && HOSTNAME_WITH_NO_PORT_PATTERN.matcher(hostnamePattern.substring(2)).matches() : HOSTNAME_WITH_NO_PORT_PATTERN.matcher(hostnamePattern).matches();
        Preconditions.checkArgument(validHostnamePattern, "hostnamePattern: %s (expected: *.<hostname> or <hostname>)", (Object)hostnamePattern);
    }

    static void ensureHostnamePatternMatchesDefaultHostname(String hostnamePattern, String defaultHostname) {
        if ("*".equals(hostnamePattern)) {
            return;
        }
        Mapping<String, Boolean> mapping = new DomainMappingBuilder<Boolean>(Boolean.FALSE).add(hostnamePattern, Boolean.TRUE).build();
        if (!mapping.map(defaultHostname).booleanValue()) {
            throw new IllegalArgumentException("defaultHostname: " + defaultHostname + " (must be matched by hostnamePattern: " + hostnamePattern + ')');
        }
    }

    private static boolean needsNormalization(String hostnamePattern) {
        int length = hostnamePattern.length();
        for (int i = 0; i < length; ++i) {
            char c = hostnamePattern.charAt(i);
            if (c <= '\u007f') continue;
            return true;
        }
        return false;
    }

    String originalHostnamePattern() {
        return this.originalHostnamePattern;
    }

    public Server server() {
        if (this.serverConfig == null) {
            throw new IllegalStateException("server is not configured yet.");
        }
        return this.serverConfig.server();
    }

    void setServerConfig(ServerConfig serverConfig) {
        if (this.serverConfig != null) {
            throw new IllegalStateException("VirtualHost cannot be added to more than one Server.");
        }
        this.serverConfig = Objects.requireNonNull(serverConfig, "serverConfig");
        MeterRegistry registry = serverConfig.meterRegistry();
        MeterIdPrefix idPrefix = new MeterIdPrefix("armeria.server.router.virtual.host.cache", "hostname.pattern", this.hostnamePattern);
        this.router.registerMetrics(registry, idPrefix);
    }

    public String defaultHostname() {
        return this.defaultHostname;
    }

    public String hostnamePattern() {
        return this.hostnamePattern;
    }

    public int port() {
        return this.port;
    }

    @Nullable
    public SslContext sslContext() {
        return this.sslContext;
    }

    @Nullable
    @UnstableApi
    public TlsEngineType tlsEngineType() {
        return this.tlsEngineType;
    }

    public List<ServiceConfig> serviceConfigs() {
        return this.serviceConfigs;
    }

    public Logger accessLogger() {
        return this.accessLogger;
    }

    public ServiceNaming defaultServiceNaming() {
        return this.defaultServiceNaming;
    }

    @Nullable
    public String defaultLogName() {
        return this.defaultLogName;
    }

    public long requestTimeoutMillis() {
        return this.requestTimeoutMillis;
    }

    public long maxRequestLength() {
        return this.maxRequestLength;
    }

    public boolean verboseResponses() {
        return this.verboseResponses;
    }

    public AccessLogWriter accessLogWriter() {
        return this.accessLogWriter;
    }

    @Deprecated
    public boolean shutdownAccessLogWriterOnStop() {
        return false;
    }

    public BlockingTaskExecutor blockingTaskExecutor() {
        return this.blockingTaskExecutor;
    }

    @Deprecated
    public boolean shutdownBlockingTaskExecutorOnStop() {
        return false;
    }

    @UnstableApi
    public EventLoopGroup serviceWorkerGroup() {
        return this.serviceWorkerGroup;
    }

    public SuccessFunction successFunction() {
        return this.successFunction;
    }

    public Function<RoutingContext, RequestId> requestIdGenerator() {
        return this.requestIdGenerator;
    }

    public Routed<ServiceConfig> findServiceConfig(RoutingContext routingCtx) {
        return this.findServiceConfig(routingCtx, false);
    }

    public Routed<ServiceConfig> findServiceConfig(RoutingContext routingCtx, boolean useFallbackService) {
        Routed<ServiceConfig> routed = this.router.find(Objects.requireNonNull(routingCtx, "routingCtx"));
        switch (routed.routingResultType()) {
            case MATCHED: {
                VirtualHost.maybeSetRoutingResult(routingCtx, routed);
                return routed;
            }
            case NOT_MATCHED: {
                if (routingCtx.method() == HttpMethod.HEAD) {
                    return this.findServiceConfig(routingCtx.withMethod(HttpMethod.GET), useFallbackService);
                }
                if (useFallbackService) break;
                VirtualHost.maybeSetRoutingResult(routingCtx, routed);
                return routed;
            }
            case CORS_PREFLIGHT: {
                assert (routingCtx.status() == RoutingStatus.CORS_PREFLIGHT);
                if (!routed.value().handlesCorsPreflight()) break;
                VirtualHost.maybeSetRoutingResult(routingCtx, routed);
                return routed;
            }
            default: {
                throw new Error();
            }
        }
        Routed<ServiceConfig> fallbackRoute = Routed.of(this.fallbackServiceConfig.route(), RoutingResult.builder().path(routingCtx.path()).query(routingCtx.query()).build(), this.fallbackServiceConfig);
        VirtualHost.maybeSetRoutingResult(routingCtx, fallbackRoute);
        return fallbackRoute;
    }

    private static void maybeSetRoutingResult(RoutingContext routingContext, Routed<ServiceConfig> routed) {
        if (!routingContext.hasResult()) {
            routingContext.setResult(routed);
        }
    }

    ServiceConfig fallbackServiceConfig() {
        return this.fallbackServiceConfig;
    }

    List<ShutdownSupport> shutdownSupports() {
        return this.shutdownSupports;
    }

    public long requestAutoAbortDelayMillis() {
        return this.requestAutoAbortDelayMillis;
    }

    public Path multipartUploadsLocation() {
        return this.multipartUploadsLocation;
    }

    @UnstableApi
    public MultipartRemovalStrategy multipartRemovalStrategy() {
        return this.multipartRemovalStrategy;
    }

    VirtualHost decorate(@Nullable Function<? super HttpService, ? extends HttpService> decorator) {
        if (decorator == null) {
            return this;
        }
        List<ServiceConfig> serviceConfigs = this.serviceConfigs.stream().map(cfg -> cfg.withDecoratedService(decorator)).collect(Collectors.toList());
        ServiceConfig fallbackServiceConfig = this.fallbackServiceConfig.withDecoratedService(decorator);
        return new VirtualHost(this.originalDefaultHostname, this.originalHostnamePattern, this.port, this.sslContext, this.tlsProvider, this.tlsEngineType, serviceConfigs, fallbackServiceConfig, RejectedRouteHandler.DISABLED, host -> this.accessLogger, this.defaultServiceNaming, this.defaultLogName, this.requestTimeoutMillis, this.maxRequestLength, this.verboseResponses, this.accessLogWriter, this.blockingTaskExecutor, this.requestAutoAbortDelayMillis, this.successFunction, this.multipartUploadsLocation, this.multipartRemovalStrategy, this.serviceWorkerGroup, this.shutdownSupports, this.requestIdGenerator);
    }

    public String toString() {
        return this.toString(true);
    }

    private String toString(boolean withTypeName) {
        StringBuilder buf = new StringBuilder();
        if (withTypeName) {
            buf.append(this.getClass().getSimpleName());
        }
        buf.append('(');
        buf.append(this.defaultHostname());
        buf.append('/');
        buf.append(this.hostnamePattern());
        buf.append(", ssl: ");
        buf.append(this.sslContext() != null);
        buf.append(", services: ");
        buf.append(this.serviceConfigs);
        buf.append(", accessLogger: ");
        buf.append(this.accessLogger());
        buf.append(", defaultServiceNaming: ");
        buf.append(this.defaultServiceNaming());
        buf.append(", requestTimeoutMillis: ");
        buf.append(this.requestTimeoutMillis());
        buf.append(", maxRequestLength: ");
        buf.append(this.maxRequestLength());
        buf.append(", verboseResponses: ");
        buf.append(this.verboseResponses());
        buf.append(", accessLogWriter: ");
        buf.append(this.accessLogWriter());
        buf.append(", blockingTaskExecutor: ");
        buf.append(this.blockingTaskExecutor());
        buf.append(", requestAutoAbortDelayMillis: ");
        buf.append(this.requestAutoAbortDelayMillis());
        buf.append(", multipartUploadsLocation: ");
        buf.append(this.multipartUploadsLocation());
        buf.append(')');
        return buf.toString();
    }

    String toStringWithoutTypeName() {
        return this.toString(false);
    }
}

