/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.common.RequestId;
import io.opentelemetry.testing.internal.armeria.common.SuccessFunction;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.BlockingTaskExecutor;
import io.opentelemetry.testing.internal.armeria.common.util.EventLoopGroups;
import io.opentelemetry.testing.internal.armeria.internal.common.RequestContextUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.server.DecoratingHttpServiceFunction;
import io.opentelemetry.testing.internal.armeria.server.ExceptionReportingServiceErrorHandler;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.MultipartRemovalStrategy;
import io.opentelemetry.testing.internal.armeria.server.Route;
import io.opentelemetry.testing.internal.armeria.server.RoutingContext;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfigSetters;
import io.opentelemetry.testing.internal.armeria.server.ServiceErrorHandler;
import io.opentelemetry.testing.internal.armeria.server.ServiceNaming;
import io.opentelemetry.testing.internal.armeria.server.ServiceOptions;
import io.opentelemetry.testing.internal.armeria.server.ShutdownSupport;
import io.opentelemetry.testing.internal.armeria.server.UnloggedExceptionsReporter;
import io.opentelemetry.testing.internal.armeria.server.VirtualHostBuilder;
import io.opentelemetry.testing.internal.armeria.server.logging.AccessLogWriter;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoopGroup;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;

final class ServiceConfigBuilder
implements ServiceConfigSetters<ServiceConfigBuilder> {
    private final Route route;
    private final HttpService service;
    @Nullable
    private Route mappedRoute;
    @Nullable
    private String defaultServiceName;
    @Nullable
    private ServiceNaming defaultServiceNaming;
    @Nullable
    private String defaultLogName;
    @Nullable
    private Long requestTimeoutMillis;
    @Nullable
    private Long maxRequestLength;
    @Nullable
    private Boolean verboseResponses;
    @Nullable
    private AccessLogWriter accessLogWriter;
    @Nullable
    private BlockingTaskExecutor blockingTaskExecutor;
    @Nullable
    private SuccessFunction successFunction;
    @Nullable
    private Long requestAutoAbortDelayMillis;
    @Nullable
    private Path multipartUploadsLocation;
    @Nullable
    private MultipartRemovalStrategy multipartRemovalStrategy;
    @Nullable
    private EventLoopGroup serviceWorkerGroup;
    @Nullable
    private ServiceErrorHandler serviceErrorHandler;
    private Supplier<AutoCloseable> contextHook = RequestContextUtil.NOOP_CONTEXT_HOOK;
    private final List<ShutdownSupport> shutdownSupports = new ArrayList<ShutdownSupport>();
    private final HttpHeadersBuilder defaultHeaders = HttpHeaders.builder();
    @Nullable
    private Function<? super RoutingContext, ? extends RequestId> requestIdGenerator;

    ServiceConfigBuilder(Route route, String contextPath, HttpService service) {
        this.route = Objects.requireNonNull(route, "route").withPrefix(contextPath);
        this.service = Objects.requireNonNull(service, "service");
        ServiceOptions options = service.options();
        if (options.requestTimeoutMillis() != -1L) {
            this.requestTimeoutMillis = options.requestTimeoutMillis();
        }
        if (options.maxRequestLength() != -1L) {
            this.maxRequestLength = options.maxRequestLength();
        }
        if (options.requestAutoAbortDelayMillis() != -1L) {
            this.requestAutoAbortDelayMillis = options.requestAutoAbortDelayMillis();
        }
    }

    void addMappedRoute(Route mappedRoute) {
        this.mappedRoute = Objects.requireNonNull(mappedRoute, "mappedRoute");
    }

    @Override
    public ServiceConfigBuilder requestTimeout(Duration requestTimeout) {
        return this.requestTimeoutMillis(requestTimeout.toMillis());
    }

    @Override
    public ServiceConfigBuilder requestTimeoutMillis(long requestTimeoutMillis) {
        this.requestTimeoutMillis = requestTimeoutMillis;
        return this;
    }

    @Override
    public ServiceConfigBuilder maxRequestLength(long maxRequestLength) {
        this.maxRequestLength = maxRequestLength;
        return this;
    }

    @Override
    public ServiceConfigBuilder verboseResponses(boolean verboseResponses) {
        this.verboseResponses = verboseResponses;
        return this;
    }

    @Override
    public ServiceConfigBuilder accessLogWriter(AccessLogWriter accessLogWriter, boolean shutdownOnStop) {
        this.accessLogWriter = this.accessLogWriter != null ? this.accessLogWriter.andThen(accessLogWriter) : accessLogWriter;
        if (shutdownOnStop) {
            this.shutdownSupports.add(ShutdownSupport.of(accessLogWriter));
        }
        return this;
    }

    @Override
    public ServiceConfigBuilder accessLogFormat(String accessLogFormat) {
        return this.accessLogWriter(AccessLogWriter.custom(Objects.requireNonNull(accessLogFormat, "accessLogFormat")), false);
    }

    @Override
    public ServiceConfigBuilder decorator(DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceConfigBuilder decorator(Function<? super HttpService, ? extends HttpService> decorator) {
        throw new UnsupportedOperationException();
    }

    @Override
    @SafeVarargs
    public final ServiceConfigBuilder decorators(Function<? super HttpService, ? extends HttpService> ... decorators) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceConfigBuilder decorators(Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceConfigBuilder defaultLogName(String defaultLogName) {
        this.defaultLogName = Objects.requireNonNull(defaultLogName, "defaultLogName");
        return this;
    }

    @Override
    public ServiceConfigBuilder blockingTaskExecutor(ScheduledExecutorService blockingTaskExecutor, boolean shutdownOnStop) {
        Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        return this.blockingTaskExecutor(BlockingTaskExecutor.of(blockingTaskExecutor), shutdownOnStop);
    }

    @Override
    public ServiceConfigBuilder blockingTaskExecutor(BlockingTaskExecutor blockingTaskExecutor, boolean shutdownOnStop) {
        this.blockingTaskExecutor = Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        if (shutdownOnStop) {
            this.shutdownSupports.add(ShutdownSupport.of(blockingTaskExecutor));
        }
        return this;
    }

    @Override
    public ServiceConfigBuilder blockingTaskExecutor(int numThreads) {
        Preconditions.checkArgument(numThreads >= 0, "numThreads: %s (expected: >= 0)", numThreads);
        BlockingTaskExecutor executor = BlockingTaskExecutor.builder().numThreads(numThreads).build();
        return this.blockingTaskExecutor(executor, true);
    }

    @Override
    public ServiceConfigBuilder successFunction(SuccessFunction successFunction) {
        this.successFunction = Objects.requireNonNull(successFunction, "successFunction");
        return this;
    }

    @Override
    public ServiceConfigBuilder requestAutoAbortDelay(Duration delay) {
        return this.requestAutoAbortDelayMillis(Objects.requireNonNull(delay, "delay").toMillis());
    }

    @Override
    public ServiceConfigBuilder requestAutoAbortDelayMillis(long delayMillis) {
        this.requestAutoAbortDelayMillis = delayMillis;
        return this;
    }

    @Override
    public ServiceConfigBuilder multipartUploadsLocation(Path multipartUploadsLocation) {
        this.multipartUploadsLocation = Objects.requireNonNull(multipartUploadsLocation, "multipartUploadsLocation");
        return this;
    }

    @Override
    public ServiceConfigBuilder multipartRemovalStrategy(MultipartRemovalStrategy removalStrategy) {
        this.multipartRemovalStrategy = Objects.requireNonNull(removalStrategy, "removalStrategy");
        return this;
    }

    @Override
    public ServiceConfigBuilder requestIdGenerator(Function<? super RoutingContext, ? extends RequestId> requestIdGenerator) {
        this.requestIdGenerator = Objects.requireNonNull(requestIdGenerator, "requestIdGenerator");
        return this;
    }

    @Override
    public ServiceConfigBuilder addHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        VirtualHostBuilder.ensureNoPseudoHeader(name);
        this.defaultHeaders.addObject(name, value);
        return this;
    }

    @Override
    public ServiceConfigBuilder addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        Objects.requireNonNull(defaultHeaders, "defaultHeaders");
        VirtualHostBuilder.ensureNoPseudoHeader(defaultHeaders);
        this.defaultHeaders.addObject(defaultHeaders);
        return this;
    }

    @Override
    public ServiceConfigBuilder setHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        VirtualHostBuilder.ensureNoPseudoHeader(name);
        this.defaultHeaders.setObject(name, value);
        return this;
    }

    @Override
    public ServiceConfigBuilder setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        Objects.requireNonNull(defaultHeaders, "defaultHeaders");
        VirtualHostBuilder.ensureNoPseudoHeader(defaultHeaders);
        this.defaultHeaders.setObject(defaultHeaders);
        return this;
    }

    @Override
    public ServiceConfigBuilder errorHandler(ServiceErrorHandler serviceErrorHandler) {
        Objects.requireNonNull(serviceErrorHandler, "serviceErrorHandler");
        this.serviceErrorHandler = this.serviceErrorHandler == null ? serviceErrorHandler : this.serviceErrorHandler.orElse(serviceErrorHandler);
        return this;
    }

    @Override
    public ServiceConfigBuilder contextHook(Supplier<? extends AutoCloseable> contextHook) {
        Objects.requireNonNull(contextHook, "contextHook");
        this.contextHook = RequestContextUtil.mergeHooks(this.contextHook, contextHook);
        return this;
    }

    @Override
    public ServiceConfigBuilder defaultServiceName(String defaultServiceName) {
        Objects.requireNonNull(defaultServiceName, "defaultServiceName");
        this.defaultServiceName = defaultServiceName;
        this.defaultServiceNaming = ServiceNaming.of(defaultServiceName);
        return this;
    }

    @Override
    public ServiceConfigBuilder defaultServiceNaming(ServiceNaming defaultServiceNaming) {
        this.defaultServiceName = null;
        this.defaultServiceNaming = Objects.requireNonNull(defaultServiceNaming, "defaultServiceNaming");
        return this;
    }

    @Override
    public ServiceConfigBuilder serviceWorkerGroup(EventLoopGroup serviceWorkerGroup, boolean shutdownOnStop) {
        this.serviceWorkerGroup = Objects.requireNonNull(serviceWorkerGroup, "serviceWorkerGroup");
        if (shutdownOnStop) {
            this.shutdownSupports.add(ShutdownSupport.of(serviceWorkerGroup));
        }
        return this;
    }

    @Override
    public ServiceConfigBuilder serviceWorkerGroup(int numThreads) {
        EventLoopGroup workerGroup = EventLoopGroups.newEventLoopGroup(numThreads);
        return this.serviceWorkerGroup(workerGroup, true);
    }

    void shutdownSupports(List<ShutdownSupport> shutdownSupports) {
        Objects.requireNonNull(shutdownSupports, "shutdownSupports");
        this.shutdownSupports.addAll(shutdownSupports);
    }

    void defaultHeaders(HttpHeaders defaultHeaders) {
        Objects.requireNonNull(defaultHeaders, "defaultHeaders");
        defaultHeaders.forEach((name, value) -> this.defaultHeaders.add((CharSequence)name, (String)value));
    }

    ServiceConfig build(ServiceNaming defaultServiceNaming, @Nullable String defaultLogName, long defaultRequestTimeoutMillis, long defaultMaxRequestLength, boolean defaultVerboseResponses, AccessLogWriter defaultAccessLogWriter, BlockingTaskExecutor defaultBlockingTaskExecutor, SuccessFunction defaultSuccessFunction, long defaultRequestAutoAbortDelayMillis, Path defaultMultipartUploadsLocation, MultipartRemovalStrategy defaultMultipartRemovalStrategy, EventLoopGroup defaultServiceWorkerGroup, HttpHeaders virtualHostDefaultHeaders, Function<? super RoutingContext, ? extends RequestId> defaultRequestIdGenerator, ServiceErrorHandler defaultServiceErrorHandler, @Nullable UnloggedExceptionsReporter unloggedExceptionsReporter, String baseContextPath, Supplier<AutoCloseable> contextHook) {
        ServiceErrorHandler errorHandler;
        ServiceErrorHandler serviceErrorHandler = errorHandler = this.serviceErrorHandler != null ? this.serviceErrorHandler.orElse(defaultServiceErrorHandler) : defaultServiceErrorHandler;
        if (unloggedExceptionsReporter != null) {
            errorHandler = new ExceptionReportingServiceErrorHandler(errorHandler, unloggedExceptionsReporter);
        }
        long requestTimeoutMillis = this.requestTimeoutMillis != null ? this.requestTimeoutMillis : defaultRequestTimeoutMillis;
        long maxRequestLength = this.maxRequestLength != null ? this.maxRequestLength : defaultMaxRequestLength;
        long requestAutoAbortDelayMillis = this.requestAutoAbortDelayMillis != null ? this.requestAutoAbortDelayMillis : defaultRequestAutoAbortDelayMillis;
        Supplier<AutoCloseable> mergedContextHook = RequestContextUtil.mergeHooks(contextHook, this.contextHook);
        Route routeWithBaseContextPath = this.route.withPrefix(baseContextPath);
        return new ServiceConfig(routeWithBaseContextPath, this.mappedRoute == null ? routeWithBaseContextPath : this.mappedRoute, this.service, this.defaultServiceName, this.defaultServiceNaming != null ? this.defaultServiceNaming : defaultServiceNaming, this.defaultLogName != null ? this.defaultLogName : defaultLogName, requestTimeoutMillis, maxRequestLength, this.verboseResponses != null ? this.verboseResponses : defaultVerboseResponses, this.accessLogWriter != null ? this.accessLogWriter : defaultAccessLogWriter, this.blockingTaskExecutor != null ? this.blockingTaskExecutor : defaultBlockingTaskExecutor, this.successFunction != null ? this.successFunction : defaultSuccessFunction, requestAutoAbortDelayMillis, this.multipartUploadsLocation != null ? this.multipartUploadsLocation : defaultMultipartUploadsLocation, this.multipartRemovalStrategy != null ? this.multipartRemovalStrategy : defaultMultipartRemovalStrategy, this.serviceWorkerGroup != null ? this.serviceWorkerGroup : defaultServiceWorkerGroup, ImmutableList.copyOf(this.shutdownSupports), VirtualHostBuilder.mergeDefaultHeaders(virtualHostDefaultHeaders.toBuilder(), this.defaultHeaders.build()), this.requestIdGenerator != null ? this.requestIdGenerator : defaultRequestIdGenerator, errorHandler, mergedContextHook);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("route", this.route).add("service", this.service).add("defaultServiceNaming", this.defaultServiceNaming).add("defaultLogName", this.defaultLogName).add("requestTimeoutMillis", this.requestTimeoutMillis).add("maxRequestLength", this.maxRequestLength).add("verboseResponses", this.verboseResponses).add("accessLogWriter", this.accessLogWriter).add("blockingTaskExecutor", this.blockingTaskExecutor).add("successFunction", this.successFunction).add("multipartUploadsLocation", this.multipartUploadsLocation).add("serviceWorkerGroup", this.serviceWorkerGroup).add("shutdownSupports", this.shutdownSupports).add("defaultHeaders", this.defaultHeaders).add("serviceErrorHandler", this.serviceErrorHandler).add("contextHook", this.contextHook).toString();
    }
}

