/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.Request;
import io.opentelemetry.testing.internal.armeria.common.Response;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.Unwrappable;
import io.opentelemetry.testing.internal.armeria.server.Route;
import io.opentelemetry.testing.internal.armeria.server.RoutePathType;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import java.util.Objects;

@FunctionalInterface
public interface Service<I extends Request, O extends Response>
extends Unwrappable {
    default public void serviceAdded(ServiceConfig cfg) throws Exception {
    }

    public O serve(ServiceRequestContext var1, I var2) throws Exception;

    @Override
    @Nullable
    default public <T> T as(Class<T> type) {
        Objects.requireNonNull(type, "type");
        return Unwrappable.super.as(type);
    }

    @Override
    default public Service<? extends Request, ? extends Response> unwrap() {
        return (Service)Unwrappable.super.unwrap();
    }

    default public boolean shouldCachePath(String path, @Nullable String query, Route route) {
        return route.pathType() == RoutePathType.EXACT && query == null;
    }
}

