/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.server.ContentPreviewServerErrorHandler;
import io.opentelemetry.testing.internal.armeria.server.CorsServerErrorHandler;
import io.opentelemetry.testing.internal.armeria.server.DecoratingServerErrorHandlerFunction;
import io.opentelemetry.testing.internal.armeria.server.ServerErrorHandler;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import java.util.List;

final class ServerErrorHandlerDecorators {
    private static final List<DecoratingServerErrorHandlerFunction> decoratorFunctions = ImmutableList.of(new CorsServerErrorHandler(), new ContentPreviewServerErrorHandler());

    private ServerErrorHandlerDecorators() {
    }

    static ServerErrorHandler decorate(ServerErrorHandler delegate) {
        ServerErrorHandler decorated = delegate;
        for (DecoratingServerErrorHandlerFunction decoratorFunction : decoratorFunctions) {
            decorated = new DecoratingServerErrorHandler(decorated, decoratorFunction);
        }
        return decorated;
    }

    private static final class DecoratingServerErrorHandler
    implements ServerErrorHandler {
        final ServerErrorHandler delegate;
        final DecoratingServerErrorHandlerFunction decoratorFunction;

        DecoratingServerErrorHandler(ServerErrorHandler delegate, DecoratingServerErrorHandlerFunction decoratorFunction) {
            this.delegate = delegate;
            this.decoratorFunction = decoratorFunction;
        }

        @Override
        @Nullable
        public HttpResponse onServiceException(ServiceRequestContext ctx, Throwable cause) {
            return this.decoratorFunction.onServiceException(this.delegate, ctx, cause);
        }

        @Override
        @Nullable
        public AggregatedHttpResponse onProtocolViolation(ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
            return this.delegate.onProtocolViolation(config, headers, status, description, cause);
        }

        @Override
        @Nullable
        public AggregatedHttpResponse renderStatus(@Nullable ServiceRequestContext ctx, ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
            return this.delegate.renderStatus(ctx, config, headers, status, description, cause);
        }
    }
}

