/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.common.ArmeriaHttpUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.util.StringUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableMap;
import io.opentelemetry.testing.internal.armeria.server.RoutingResultBuilder;
import io.opentelemetry.testing.internal.armeria.server.RoutingResultType;
import java.util.Map;

public final class RoutingResult {
    static final int LOWEST_SCORE = Integer.MIN_VALUE;
    static final int HIGHEST_SCORE = Integer.MAX_VALUE;
    private static final RoutingResult EMPTY = new RoutingResult(RoutingResultType.NOT_MATCHED, null, null, ImmutableMap.of(), Integer.MIN_VALUE, null);
    private static final RoutingResult EXCLUDED = new RoutingResult(RoutingResultType.NOT_MATCHED, null, null, ImmutableMap.of(), Integer.MIN_VALUE, null);
    private final RoutingResultType type;
    @Nullable
    private final String path;
    @Nullable
    private final String query;
    private final Map<String, String> pathParams;
    @Nullable
    private String decodedPath;
    private final int score;
    @Nullable
    private final MediaType negotiatedResponseMediaType;

    public static RoutingResult empty() {
        return EMPTY;
    }

    public static RoutingResult excluded() {
        return EXCLUDED;
    }

    public static RoutingResultBuilder builder() {
        return new RoutingResultBuilder();
    }

    static RoutingResultBuilder builderWithExpectedNumParams(int numParams) {
        return new RoutingResultBuilder(numParams);
    }

    RoutingResult(RoutingResultType type, @Nullable String path, @Nullable String query, Map<String, String> pathParams, int score, @Nullable MediaType negotiatedResponseMediaType) {
        assert (type != RoutingResultType.NOT_MATCHED || path == null && query == null && pathParams.isEmpty());
        this.type = type;
        this.path = path;
        this.query = query;
        this.pathParams = ImmutableMap.copyOf(pathParams);
        this.score = score;
        this.negotiatedResponseMediaType = negotiatedResponseMediaType;
    }

    public RoutingResultType type() {
        return this.type;
    }

    public boolean isPresent() {
        return this.path != null;
    }

    public String path() {
        this.ensurePresence();
        assert (this.path != null);
        return this.path;
    }

    private void ensurePresence() {
        if (!this.isPresent()) {
            throw new IllegalStateException("routing unavailable");
        }
    }

    public String decodedPath() {
        this.ensurePresence();
        String decodedPath = this.decodedPath;
        if (decodedPath != null) {
            return decodedPath;
        }
        assert (this.path != null);
        this.decodedPath = ArmeriaHttpUtil.decodePath(this.path);
        return this.decodedPath;
    }

    @Nullable
    public String query() {
        this.ensurePresence();
        return this.query;
    }

    public Map<String, String> pathParams() {
        this.ensurePresence();
        return this.pathParams;
    }

    public int score() {
        this.ensurePresence();
        return this.score;
    }

    public boolean hasHighestScore() {
        return Integer.MAX_VALUE == this.score();
    }

    public boolean hasLowestScore() {
        return Integer.MIN_VALUE == this.score();
    }

    @Nullable
    public MediaType negotiatedResponseMediaType() {
        this.ensurePresence();
        return this.negotiatedResponseMediaType;
    }

    public String toString() {
        if (this.isPresent()) {
            String score = StringUtil.toString(this.score);
            if (this.hasHighestScore()) {
                score = score + " (highest)";
            } else if (this.hasLowestScore()) {
                score = score + " (lowest)";
            }
            return MoreObjects.toStringHelper(this).omitNullValues().add("type", (Object)this.type).add("path", this.path).add("query", this.query).add("pathParams", this.pathParams).add("score", score).add("negotiatedResponseMediaType", this.negotiatedResponseMediaType).toString();
        }
        return this.getClass().getSimpleName() + "{<empty>}";
    }
}

