/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.RequestHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Maps;
import io.opentelemetry.testing.internal.io.netty.handler.codec.CharSequenceValueConverter;
import io.opentelemetry.testing.internal.io.netty.handler.codec.DefaultHeaders;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpHeaders;
import io.opentelemetry.testing.internal.io.netty.util.AsciiString;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

final class NettyHttp1Headers
extends HttpHeaders {
    private static final DefaultHeaders.NameValidator<CharSequence> NAME_VALIDATOR = DefaultHttpHeadersFactory.headersFactory().getNameValidator();
    private static final DefaultHeaders.ValueValidator<CharSequence> VALUE_VALIDATOR = DefaultHttpHeadersFactory.headersFactory().getValueValidator();
    private final RequestHeadersBuilder delegate = RequestHeaders.builder();

    NettyHttp1Headers() {
    }

    @Override
    @Nullable
    public String get(String name) {
        return this.delegate.get(name);
    }

    @Override
    @Nullable
    public Integer getInt(CharSequence name) {
        return this.delegate.getInt(name);
    }

    @Override
    public int getInt(CharSequence name, int defaultValue) {
        return this.delegate.getInt(name, defaultValue);
    }

    @Override
    @Nullable
    public Short getShort(CharSequence name) {
        Integer intValue = this.delegate.getInt(name);
        if (intValue == null || intValue < Short.MIN_VALUE || intValue > Short.MAX_VALUE) {
            return null;
        }
        return intValue.shortValue();
    }

    @Override
    public short getShort(CharSequence name, short defaultValue) {
        Integer intValue = this.delegate.getInt(name);
        if (intValue == null || intValue < Short.MIN_VALUE || intValue > Short.MAX_VALUE) {
            return defaultValue;
        }
        return intValue.shortValue();
    }

    @Override
    @Nullable
    public Long getTimeMillis(CharSequence name) {
        return this.delegate.getTimeMillis(name);
    }

    @Override
    public long getTimeMillis(CharSequence name, long defaultValue) {
        return this.delegate.getTimeMillis(name, defaultValue);
    }

    @Override
    public List<String> getAll(String name) {
        return this.delegate.getAll(name);
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        return this.delegate.stream().map(e -> Maps.immutableEntry(((AsciiString)e.getKey()).toString(), (String)e.getValue())).collect(Collectors.toList());
    }

    @Override
    public boolean contains(String name) {
        return this.delegate.contains(name);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.delegate.stream().map(e -> Maps.immutableEntry(((AsciiString)e.getKey()).toString(), (String)e.getValue())).iterator();
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return this.delegate.stream().map(e -> Maps.immutableEntry(((AsciiString)e.getKey()).toString(), (CharSequence)e.getValue())).iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Set<String> names() {
        return this.delegate.names().stream().map(AsciiString::toString).collect(Collectors.toSet());
    }

    @Override
    public HttpHeaders add(String name, Object value) {
        String strValue = NettyHttp1Headers.validateValue(value);
        this.delegate.add(NettyHttp1Headers.validatedName(name), strValue);
        return this;
    }

    @Override
    public HttpHeaders add(String name, Iterable<?> values) {
        this.delegate.add(NettyHttp1Headers.validatedName(name), NettyHttp1Headers.validateValues(values));
        return this;
    }

    @Override
    public HttpHeaders addInt(CharSequence name, int value) {
        this.delegate.addInt(NettyHttp1Headers.validatedName(name), value);
        return this;
    }

    @Override
    public HttpHeaders addShort(CharSequence name, short value) {
        this.delegate.addInt(NettyHttp1Headers.validatedName(name), value);
        return this;
    }

    @Override
    public HttpHeaders set(String name, Object value) {
        this.delegate.set(NettyHttp1Headers.validatedName(name), NettyHttp1Headers.validateValue(value));
        return this;
    }

    @Override
    public HttpHeaders set(String name, Iterable<?> values) {
        List<String> strValues = NettyHttp1Headers.validateValues(values);
        this.delegate.set(NettyHttp1Headers.validatedName(name), strValues);
        return this;
    }

    @Override
    public HttpHeaders setInt(CharSequence name, int value) {
        this.delegate.setInt(NettyHttp1Headers.validatedName(name), value);
        return this;
    }

    @Override
    public HttpHeaders setShort(CharSequence name, short value) {
        this.delegate.setInt(NettyHttp1Headers.validatedName(name), value);
        return this;
    }

    @Override
    public HttpHeaders remove(String name) {
        this.delegate.remove(name);
        return this;
    }

    @Override
    public HttpHeaders clear() {
        this.delegate.clear();
        return this;
    }

    private static CharSequence validatedName(CharSequence name) {
        NAME_VALIDATOR.validateName(name);
        return name;
    }

    private static List<String> validateValues(Iterable<?> values) {
        return ImmutableList.copyOf(values).stream().map(NettyHttp1Headers::validateValue).collect(Collectors.toList());
    }

    private static String validateValue(Object value) {
        CharSequence strValue = CharSequenceValueConverter.INSTANCE.convertObject(value);
        VALUE_VALIDATOR.validate(strValue);
        return strValue.toString();
    }

    RequestHeadersBuilder delegate() {
        return this.delegate;
    }
}

