/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.internal.common.AbstractHttp2ConnectionHandlerBuilder;
import io.opentelemetry.testing.internal.armeria.server.GracefulShutdownSupport;
import io.opentelemetry.testing.internal.armeria.server.Http2ServerConnectionHandler;
import io.opentelemetry.testing.internal.armeria.server.ServerConfig;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.Timer;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2Settings;
import io.opentelemetry.testing.internal.io.netty.util.AsciiString;

final class Http2ServerConnectionHandlerBuilder
extends AbstractHttp2ConnectionHandlerBuilder<Http2ServerConnectionHandler, Http2ServerConnectionHandlerBuilder> {
    private final ServerConfig config;
    private final Timer keepAliveTimer;
    private final GracefulShutdownSupport gracefulShutdownSupport;
    private final AsciiString scheme;

    Http2ServerConnectionHandlerBuilder(Channel ch, ServerConfig config, Timer keepAliveTimer, GracefulShutdownSupport gracefulShutdownSupport, AsciiString scheme) {
        super(ch);
        this.config = config;
        this.keepAliveTimer = keepAliveTimer;
        this.gracefulShutdownSupport = gracefulShutdownSupport;
        this.scheme = scheme;
        this.gracefulShutdownTimeoutMillis(-1L);
        this.decoderEnforceMaxRstFramesPerWindow(config.http2MaxResetFramesPerWindow(), config.http2MaxResetFramesWindowSeconds());
    }

    @Override
    protected Http2ServerConnectionHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) throws Exception {
        return new Http2ServerConnectionHandler(decoder, encoder, initialSettings, this.channel(), this.config, this.keepAliveTimer, this.gracefulShutdownSupport, this.scheme);
    }
}

