/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.ContentTooLargeException;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.ShuttingDownException;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.internal.common.RequestContextExtension;
import io.opentelemetry.testing.internal.armeria.internal.common.util.TemporaryThreadLocals;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.server.DecodedHttpRequest;
import io.opentelemetry.testing.internal.armeria.server.HttpResponseException;
import io.opentelemetry.testing.internal.armeria.server.HttpStatusException;
import io.opentelemetry.testing.internal.armeria.server.RequestCancellationException;
import io.opentelemetry.testing.internal.armeria.server.RequestTimeoutException;
import io.opentelemetry.testing.internal.armeria.server.ServerErrorHandler;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.annotation.AnnotatedService;
import javax.annotation.Nonnull;

final class DefaultServerErrorHandler
extends Enum<DefaultServerErrorHandler>
implements ServerErrorHandler {
    public static final /* enum */ DefaultServerErrorHandler INSTANCE = new DefaultServerErrorHandler();
    private static final /* synthetic */ DefaultServerErrorHandler[] $VALUES;

    public static DefaultServerErrorHandler[] values() {
        return (DefaultServerErrorHandler[])$VALUES.clone();
    }

    public static DefaultServerErrorHandler valueOf(String name) {
        return Enum.valueOf(DefaultServerErrorHandler.class, name);
    }

    @Override
    @Nonnull
    public HttpResponse onServiceException(ServiceRequestContext ctx, Throwable cause) {
        boolean isAnnotatedService;
        boolean bl = isAnnotatedService = ctx.config().service().as(AnnotatedService.class) != null;
        if (isAnnotatedService && cause instanceof IllegalArgumentException) {
            return DefaultServerErrorHandler.internalRenderStatus(ctx, ctx.request().headers(), HttpStatus.BAD_REQUEST, cause);
        }
        if (cause instanceof HttpStatusException || cause instanceof HttpResponseException) {
            return HttpResponse.ofFailure(cause);
        }
        if (cause instanceof ContentTooLargeException) {
            return DefaultServerErrorHandler.internalRenderStatus(ctx, ctx.request().headers(), HttpStatus.REQUEST_ENTITY_TOO_LARGE, cause);
        }
        if (cause instanceof RequestCancellationException) {
            return HttpResponse.ofFailure(cause);
        }
        if (cause instanceof RequestTimeoutException) {
            RequestContextExtension ctxExtension = ctx.as(RequestContextExtension.class);
            assert (ctxExtension != null);
            DecodedHttpRequest request = (DecodedHttpRequest)ctxExtension.originalRequest();
            HttpStatus status = request.isClosedSuccessfully() ? HttpStatus.SERVICE_UNAVAILABLE : HttpStatus.REQUEST_TIMEOUT;
            return DefaultServerErrorHandler.internalRenderStatus(ctx, ctx.request().headers(), status, cause);
        }
        if (cause instanceof ShuttingDownException) {
            return DefaultServerErrorHandler.internalRenderStatus(ctx, ctx.request().headers(), HttpStatus.SERVICE_UNAVAILABLE, cause);
        }
        return DefaultServerErrorHandler.internalRenderStatus(ctx, ctx.request().headers(), HttpStatus.INTERNAL_SERVER_ERROR, cause);
    }

    private static HttpResponse internalRenderStatus(ServiceRequestContext ctx, RequestHeaders headers, HttpStatus status, @Nullable Throwable cause) {
        ServiceConfig serviceConfig = ctx.config();
        AggregatedHttpResponse res = serviceConfig.server().config().errorHandler().renderStatus(ctx, serviceConfig, headers, status, null, cause);
        assert (res != null);
        return res.toHttpResponse();
    }

    @Override
    @Nonnull
    public AggregatedHttpResponse renderStatus(@Nullable ServiceRequestContext ctx, ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
        HttpData content;
        if (status.isContentAlwaysEmpty()) {
            return AggregatedHttpResponse.of(ResponseHeaders.of(status));
        }
        try (TemporaryThreadLocals ttl = TemporaryThreadLocals.acquire();){
            StringBuilder buf = ttl.stringBuilder();
            buf.append("Status: ").append(status.codeAsText()).append('\n');
            buf.append("Description: ").append(MoreObjects.firstNonNull(description, status.reasonPhrase())).append('\n');
            if (cause != null && config.verboseResponses() && !status.isSuccess()) {
                buf.append("Stack trace:\n");
                buf.append(Exceptions.traceText(cause));
            }
            content = HttpData.ofUtf8(buf);
        }
        return AggregatedHttpResponse.of(status, MediaType.PLAIN_TEXT_UTF_8, content);
    }

    private static /* synthetic */ DefaultServerErrorHandler[] $values() {
        return new DefaultServerErrorHandler[]{INSTANCE};
    }

    static {
        $VALUES = DefaultServerErrorHandler.$values();
    }
}

