/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.server.GracefulShutdown;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;

final class DefaultGracefulShutdown
implements GracefulShutdown {
    private final Duration quietPeriod;
    private final Duration timeout;
    private final BiFunction<ServiceRequestContext, HttpRequest, Throwable> toExceptionFunction;

    DefaultGracefulShutdown(Duration quietPeriod, Duration timeout, BiFunction<ServiceRequestContext, HttpRequest, Throwable> toExceptionFunction) {
        this.quietPeriod = quietPeriod;
        this.timeout = timeout;
        this.toExceptionFunction = toExceptionFunction;
    }

    @Override
    public Duration quietPeriod() {
        return this.quietPeriod;
    }

    @Override
    public Duration timeout() {
        return this.timeout;
    }

    @Override
    public Throwable toException(ServiceRequestContext ctx, HttpRequest request) {
        return this.toExceptionFunction.apply(ctx, request);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultGracefulShutdown)) {
            return false;
        }
        DefaultGracefulShutdown that = (DefaultGracefulShutdown)o;
        return this.quietPeriod.equals(that.quietPeriod) && this.timeout.equals(that.timeout) && this.toExceptionFunction.equals(that.toExceptionFunction);
    }

    public int hashCode() {
        return Objects.hash(this.quietPeriod, this.timeout, this.toExceptionFunction);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("quietPeriod", this.quietPeriod).add("timeout", this.timeout).add("toExceptionFunction", this.toExceptionFunction).toString();
    }
}

