/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.logging.ContentPreviewingUtil;
import io.opentelemetry.testing.internal.armeria.server.DecoratingServerErrorHandlerFunction;
import io.opentelemetry.testing.internal.armeria.server.ServerErrorHandler;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.logging.ContentPreviewingService;

final class ContentPreviewServerErrorHandler
implements DecoratingServerErrorHandlerFunction {
    ContentPreviewServerErrorHandler() {
    }

    @Override
    @Nullable
    public HttpResponse onServiceException(ServerErrorHandler delegate, ServiceRequestContext ctx, Throwable cause) {
        HttpResponse res = delegate.onServiceException(ctx, cause);
        ContentPreviewingService contentPreviewingService = ctx.findService(ContentPreviewingService.class);
        if (contentPreviewingService == null) {
            return res;
        }
        if (res != null) {
            return ContentPreviewingUtil.setUpResponseContentPreviewer(contentPreviewingService.contentPreviewerFactory(), ctx, res, contentPreviewingService.responsePreviewSanitizer());
        }
        ctx.logBuilder().responseContentPreview(null);
        return res;
    }
}

